/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockTripWire;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(info="Implements RedstoneComponent and uses methods from it.", since="1.4.0.0-PN")
public class BlockTripWireHook
extends BlockTransparentMeta
implements RedstoneComponent {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, BlockTripWire.ATTACHED, CommonBlockProperties.POWERED);

    public BlockTripWireHook() {
        this(0);
    }

    public BlockTripWireHook(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Tripwire Hook";
    }

    @Override
    public int getId() {
        return 131;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    public BlockFace getFacing() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 3);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.getSide(this.getFacing().getOpposite()).isNormalBlock()) {
                this.level.useBreakOn(this);
            }
            return type;
        }
        if (type == 3) {
            this.calculateState(false, true, -1, null);
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (!this.getSide(face.getOpposite()).isNormalBlock() || face == BlockFace.DOWN || face == BlockFace.UP) {
            return false;
        }
        if (face.getAxis().isHorizontal()) {
            this.setFace(face);
        }
        this.level.setBlock(this, this);
        if (player != null) {
            this.calculateState(false, false, -1, null);
        }
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        super.onBreak(item);
        boolean attached = this.isAttached();
        boolean powered = this.isPowered();
        if (attached || powered) {
            this.calculateState(true, false, -1, null);
        }
        if (powered) {
            this.updateAroundRedstone(new BlockFace[0]);
            RedstoneComponent.updateAroundRedstone((Position)this.getSide(this.getFacing().getOpposite()), new BlockFace[0]);
        }
        return true;
    }

    public void calculateState(boolean onBreak, boolean updateAround, int pos, Block block) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return;
        }
        BlockFace facing = this.getFacing();
        Location position = this.getLocation();
        boolean attached = this.isAttached();
        boolean powered = this.isPowered();
        boolean canConnect = !onBreak;
        boolean nextPowered = false;
        int distance = 0;
        Block[] blocks = new Block[42];
        for (int i = 1; i < 42; ++i) {
            Position vector = position.getSide(facing, i);
            Block b = this.level.getBlock(vector);
            if (b instanceof BlockTripWireHook) {
                if (((BlockTripWireHook)b).getFacing() != facing.getOpposite()) break;
                distance = i;
                break;
            }
            if (b.getId() != 132 && i != pos) {
                blocks[i] = null;
                canConnect = false;
                continue;
            }
            if (i == pos) {
                Block block2 = b = block != null ? block : b;
            }
            if (b instanceof BlockTripWire) {
                boolean disarmed = !((BlockTripWire)b).isDisarmed();
                boolean wirePowered = ((BlockTripWire)b).isPowered();
                nextPowered |= disarmed && wirePowered;
                if (i == pos) {
                    this.level.scheduleUpdate(this, 10);
                    canConnect &= disarmed;
                }
            }
            blocks[i] = b;
        }
        boolean bl = distance > 1;
        BlockTripWireHook hook = (BlockTripWireHook)Block.get(131);
        hook.setAttached(canConnect);
        hook.setPowered(nextPowered &= (canConnect &= bl));
        if (distance > 0) {
            Position p = position.getSide(facing, distance);
            BlockFace face = facing.getOpposite();
            hook.setFace(face);
            this.level.setBlock((Vector3)p, hook, true, false);
            RedstoneComponent.updateAroundRedstone(p, new BlockFace[0]);
            RedstoneComponent.updateAroundRedstone(p.getSide(face.getOpposite()), new BlockFace[0]);
            this.addSound(p, canConnect, nextPowered, attached, powered);
        }
        this.addSound(position, canConnect, nextPowered, attached, powered);
        if (!onBreak) {
            hook.setFace(facing);
            this.level.setBlock((Vector3)position, hook, true, false);
            if (updateAround) {
                this.updateAroundRedstone(new BlockFace[0]);
                RedstoneComponent.updateAroundRedstone(position.getSide(facing.getOpposite()), new BlockFace[0]);
            }
        }
        if (attached != canConnect) {
            for (int i = 1; i < distance; ++i) {
                Position vc = position.getSide(facing, i);
                block = blocks[i];
                if (block == null || this.level.getBlockIdAt(vc.getFloorX(), vc.getFloorY(), vc.getFloorZ()) == 0) continue;
                if (canConnect ^ (block.getDamage() & 4) > 0) {
                    block.setDamage(block.getDamage() ^ 4);
                }
                this.level.setBlock((Vector3)vc, block, true, false);
            }
        }
    }

    private void addSound(Vector3 pos, boolean canConnect, boolean nextPowered, boolean attached, boolean powered) {
        if (nextPowered && !powered) {
            this.level.addLevelSoundEvent(pos, 73);
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
        } else if (!nextPowered && powered) {
            this.level.addLevelSoundEvent(pos, 74);
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
        } else if (canConnect && !attached) {
            this.level.addLevelSoundEvent(pos, 75);
        } else if (!canConnect && attached) {
            this.level.addLevelSoundEvent(pos, 76);
        }
    }

    public boolean isAttached() {
        return (this.getDamage() & 4) > 0;
    }

    public boolean isPowered() {
        return (this.getDamage() & 8) > 0;
    }

    public void setPowered(boolean value) {
        if (value ^ this.isPowered()) {
            this.setDamage(this.getDamage() ^ 8);
        }
    }

    public void setAttached(boolean value) {
        if (value ^ this.isAttached()) {
            this.setDamage(this.getDamage() ^ 4);
        }
    }

    public void setFace(BlockFace face) {
        this.setDamage(this.getDamage() - this.getDamage() % 4);
        this.setDamage(this.getDamage() | face.getHorizontalIndex());
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getWeakPower(BlockFace face) {
        return this.isPowered() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.isPowered() ? 0 : (this.getFacing() == side ? 15 : 0);
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }
}

