/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockWood;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.value.WoodType;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockWoodBark
extends BlockWood {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final String STRIPPED_BIT = "stripped_bit";
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(WoodType.PROPERTY, new BooleanBlockProperty("stripped_bit", true), CommonBlockProperties.PILLAR_AXIS);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockWoodBark() {
        this(0);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockWoodBark(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 467;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return (this.isStripped() ? "Stripped " : "") + this.getWoodType().getEnglishName() + " Wood";
    }

    @Override
    @PowerNukkitOnly
    public WoodType getWoodType() {
        return this.getPropertyValue(WoodType.PROPERTY);
    }

    @Override
    @PowerNukkitOnly
    public void setWoodType(WoodType woodType) {
        this.setPropertyValue(WoodType.PROPERTY, woodType);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isStripped() {
        return this.getBooleanValue(STRIPPED_BIT);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setStripped(boolean stripped) {
        this.setBooleanValue(STRIPPED_BIT, stripped);
    }
}

