/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemRecord;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.Objects;

public class BlockEntityJukebox
extends BlockEntitySpawnable {
    private Item recordItem;

    public BlockEntityJukebox(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.recordItem = this.namedTag.contains("RecordItem") ? NBTIO.getItemHelper(this.namedTag.getCompound("RecordItem")) : Item.get(0);
        super.initBlockEntity();
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getLevel().getBlockIdAt(this.getFloorX(), this.getFloorY(), this.getFloorZ()) == 84;
    }

    public void setRecordItem(Item recordItem) {
        Objects.requireNonNull(recordItem, "Record item cannot be null");
        this.recordItem = recordItem;
    }

    public Item getRecordItem() {
        return this.recordItem;
    }

    @PowerNukkitDifference(info="Using new method to play sounds", since="1.4.0.0-PN")
    public void play() {
        if (this.recordItem instanceof ItemRecord) {
            switch (this.recordItem.getId()) {
                case 500: {
                    this.getLevel().addSound(this, Sound.RECORD_13);
                    break;
                }
                case 501: {
                    this.getLevel().addSound(this, Sound.RECORD_CAT);
                    break;
                }
                case 502: {
                    this.getLevel().addSound(this, Sound.RECORD_BLOCKS);
                    break;
                }
                case 503: {
                    this.getLevel().addSound(this, Sound.RECORD_CHIRP);
                    break;
                }
                case 504: {
                    this.getLevel().addSound(this, Sound.RECORD_FAR);
                    break;
                }
                case 505: {
                    this.getLevel().addSound(this, Sound.RECORD_MALL);
                    break;
                }
                case 506: {
                    this.getLevel().addSound(this, Sound.RECORD_MELLOHI);
                    break;
                }
                case 507: {
                    this.getLevel().addSound(this, Sound.RECORD_STAL);
                    break;
                }
                case 508: {
                    this.getLevel().addSound(this, Sound.RECORD_STRAD);
                    break;
                }
                case 509: {
                    this.getLevel().addSound(this, Sound.RECORD_WARD);
                    break;
                }
                case 510: {
                    this.getLevel().addSound(this, Sound.RECORD_11);
                    break;
                }
                case 511: {
                    this.getLevel().addSound(this, Sound.RECORD_WAIT);
                    break;
                }
                case 759: {
                    this.getLevel().addSound(this, Sound.RECORD_PIGSTEP);
                }
            }
        }
    }

    public void stop() {
        this.getLevel().addLevelSoundEvent(this, 113);
    }

    public void dropItem() {
        if (this.recordItem.getId() != 0) {
            this.stop();
            this.level.dropItem(this.up(), this.recordItem);
            this.recordItem = Item.get(0);
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putCompound("RecordItem", NBTIO.putItemHelper(this.recordItem));
    }

    @Override
    public CompoundTag getSpawnCompound() {
        return BlockEntityJukebox.getDefaultCompound(this, "Jukebox").putCompound("RecordItem", NBTIO.putItemHelper(this.recordItem));
    }

    @Override
    public void onBreak() {
        this.dropItem();
    }
}

