/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntityPistonArm;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.nbt.tag.CompoundTag;
import javax.annotation.Nullable;

public class BlockEntityMovingBlock
extends BlockEntitySpawnable {
    @PowerNukkitOnly
    protected String blockString;
    protected Block block;
    protected BlockVector3 piston;

    public BlockEntityMovingBlock(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (this.namedTag.contains("movingBlock")) {
            CompoundTag blockData = this.namedTag.getCompound("movingBlock");
            this.blockString = blockData.getString("name");
            this.block = Block.get(blockData.getInt("id"), blockData.getInt("meta"));
        } else {
            this.close();
        }
        this.piston = this.namedTag.contains("pistonPosX") && this.namedTag.contains("pistonPosY") && this.namedTag.contains("pistonPosZ") ? new BlockVector3(this.namedTag.getInt("pistonPosX"), this.namedTag.getInt("pistonPosY"), this.namedTag.getInt("pistonPosZ")) : new BlockVector3(0, -1, 0);
        super.initBlockEntity();
    }

    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="renamed", replaceWith="getMovingBlockEntityCompound()")
    public CompoundTag getBlockEntity() {
        return this.getMovingBlockEntityCompound();
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public CompoundTag getMovingBlockEntityCompound() {
        if (this.namedTag.contains("movingEntity")) {
            return this.namedTag.getCompound("movingEntity");
        }
        return null;
    }

    @PowerNukkitOnly
    public Block getMovingBlock() {
        return this.block;
    }

    @PowerNukkitOnly
    public String getMovingBlockString() {
        return this.blockString;
    }

    @PowerNukkitOnly
    public void moveCollidedEntities(BlockEntityPistonArm piston, BlockFace moveDirection) {
        Entity[] entities;
        AxisAlignedBB bb = this.block.getBoundingBox();
        if (bb == null) {
            return;
        }
        bb = bb.getOffsetBoundingBox(this.x + (double)(piston.progress * (float)moveDirection.getXOffset()) - (double)moveDirection.getXOffset(), this.y + (double)(piston.progress * (float)moveDirection.getYOffset()) - (double)moveDirection.getYOffset(), this.z + (double)(piston.progress * (float)moveDirection.getZOffset()) - (double)moveDirection.getZOffset());
        for (Entity entity : entities = this.level.getCollidingEntities(bb)) {
            piston.moveEntity(entity, moveDirection);
        }
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.level.getBlockIdAt(this.getFloorX(), this.getFloorY(), this.getFloorZ()) == 250;
    }
}

