/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.BlockEntityDataPacket;
import java.io.IOException;
import java.nio.ByteOrder;

public abstract class BlockEntitySpawnable
extends BlockEntity {
    public BlockEntitySpawnable(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        super.initBlockEntity();
        this.spawnToAll();
    }

    public CompoundTag getSpawnCompound() {
        return this.namedTag;
    }

    public void spawnTo(Player player) {
        if (this.closed) {
            return;
        }
        player.dataPacket(this.getSpawnPacket());
    }

    @PowerNukkitOnly
    public BlockEntityDataPacket getSpawnPacket() {
        return this.getSpawnPacket(null);
    }

    @PowerNukkitOnly
    public BlockEntityDataPacket getSpawnPacket(CompoundTag nbt) {
        if (nbt == null) {
            nbt = this.getSpawnCompound();
        }
        BlockEntityDataPacket pk = new BlockEntityDataPacket();
        pk.x = (int)this.x;
        pk.y = (int)this.y;
        pk.z = (int)this.z;
        try {
            pk.namedTag = NBTIO.write(nbt, ByteOrder.LITTLE_ENDIAN, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pk;
    }

    public void spawnToAll() {
        if (this.closed) {
            return;
        }
        for (Player player : this.getLevel().getChunkPlayers(this.chunk.getX(), this.chunk.getZ()).values()) {
            if (!player.spawned) continue;
            this.spawnTo(player);
        }
    }

    public boolean updateCompoundTag(CompoundTag nbt, Player player) {
        return false;
    }
}

