/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.api.Unsigned;
import cn.nukkit.block.Block;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.UnknownRuntimeIdException;
import cn.nukkit.blockstate.BlockStateRegistry;
import cn.nukkit.blockstate.BlockStateRepair;
import cn.nukkit.blockstate.IBlockState;
import cn.nukkit.blockstate.MutableBlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateDataTypeException;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Level;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.OptionalBoolean;
import cn.nukkit.utils.Validation;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public final class BlockState
implements Serializable,
IBlockState {
    private static final long serialVersionUID = 623759888114628578L;
    private static final BigInteger SIXTEEN = BigInteger.valueOf(16L);
    private static final BigInteger BYTE_LIMIT = BigInteger.valueOf(127L);
    private static final BigInteger INT_LIMIT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_LIMIT = BigInteger.valueOf(Long.MAX_VALUE);
    private static final ZeroStorage ZERO_STORAGE = new ZeroStorage();
    private static final BlockState[][] STATES_COMMON = new BlockState[16][Block.MAX_BLOCK_ID];
    private static final ConcurrentMap<String, BlockState> STATES_UNCOMMON = new ConcurrentHashMap<String, BlockState>();
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockState AIR = BlockState.of(0, 0);
    @Nonnegative
    private final int blockId;
    @Nonnull
    @Nonnegative
    private final Storage storage;
    @Nonnull
    private OptionalBoolean valid = OptionalBoolean.empty();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlockState growCommonPool(@Nonnegative int blockId, @Nonnegative byte blockData) {
        BlockState[][] blockStateArray = STATES_COMMON;
        synchronized (STATES_COMMON) {
            BlockState state;
            BlockState[] blockIds = STATES_COMMON[blockData];
            int newLen = blockId + 1;
            if (blockIds.length < newLen) {
                blockIds = Arrays.copyOf(blockIds, blockId + 1);
                BlockState.STATES_COMMON[blockData] = blockIds;
            }
            blockIds[blockId] = state = new BlockState(blockId, blockData);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return state;
        }
    }

    private static BlockState of0xF(@Nonnegative int blockId, @Nonnegative byte blockData) {
        BlockState newState;
        BlockState[] blockIds = STATES_COMMON[blockData];
        if (blockIds.length <= blockId) {
            return BlockState.growCommonPool(blockId, blockData);
        }
        BlockState state = blockIds[blockId];
        if (state != null) {
            return state;
        }
        blockIds[blockId] = newState = new BlockState(blockId, blockData);
        return newState;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState of(@Nonnegative int blockId) {
        return BlockState.of0xF(blockId, (byte)0);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState of(@Nonnegative int blockId, @Nonnegative byte blockData) {
        Validation.checkPositive("blockData", blockData);
        if (blockData < 16) {
            return BlockState.of0xF(blockId, blockData);
        }
        return STATES_UNCOMMON.computeIfAbsent(blockId + ":" + blockData, k -> new BlockState(blockId, blockData));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState of(@Nonnegative int blockId, @Nonnegative int blockData) {
        Validation.checkPositive("blockData", blockData);
        if (blockData < 16) {
            return BlockState.of0xF(blockId, (byte)blockData);
        }
        return STATES_UNCOMMON.computeIfAbsent(blockId + ":" + blockData, k -> new BlockState(blockId, blockData));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState of(@Nonnegative int blockId, @Nonnegative long blockData) {
        Validation.checkPositive("blockData", blockData);
        if (blockData < 16L) {
            return BlockState.of0xF(blockId, (byte)blockData);
        }
        return STATES_UNCOMMON.computeIfAbsent(blockId + ":" + blockData, k -> new BlockState(blockId, blockData));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState of(@Nonnegative int blockId, @Nonnegative BigInteger blockData) {
        Validation.checkPositive("blockData", blockData);
        if (blockData.compareTo(SIXTEEN) < 0) {
            return BlockState.of0xF(blockId, blockData.byteValue());
        }
        return STATES_UNCOMMON.computeIfAbsent(blockId + ":" + blockData, k -> new BlockState(blockId, blockData));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState of(@Nonnegative int blockId, @Nonnegative Number blockData) {
        Class<?> c = blockData.getClass();
        if (c == Byte.class) {
            return BlockState.of(blockId, blockData.byteValue());
        }
        if (c == Integer.class) {
            return BlockState.of(blockId, blockData.intValue());
        }
        if (c == Long.class) {
            return BlockState.of(blockId, blockData.longValue());
        }
        if (c == BigInteger.class) {
            return BlockState.of(blockId, (BigInteger)blockData);
        }
        throw new InvalidBlockStateDataTypeException(blockData);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static BlockState of(@Nonnull String persistedStateId) {
        return BlockState.of(persistedStateId, true);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static BlockState of(@Nonnull String persistedStateId, boolean useDefaultPropertyValues) {
        String[] stateParts = persistedStateId.split(";");
        String namespacedId = stateParts[0];
        int id = Optional.ofNullable(BlockStateRegistry.getBlockId(namespacedId)).map(OptionalInt::of).orElse(OptionalInt.empty()).orElseThrow(() -> new NoSuchElementException("Block " + namespacedId + " not found."));
        BlockState state = BlockState.of(id);
        if (stateParts.length == 1 && useDefaultPropertyValues) {
            return state;
        }
        if (stateParts.length == 2 && (stateParts[1].startsWith("nukkit-unknown=") || stateParts[1].startsWith("unknown="))) {
            BigInteger damage = new BigInteger(stateParts[1].split("=", 2)[1]);
            return BlockState.of(id, damage);
        }
        if (stateParts.length == 1 && state.getPropertyNames().isEmpty()) {
            return state;
        }
        if (useDefaultPropertyValues) {
            for (int i = 1; i < stateParts.length; ++i) {
                String[] propertyKeyValue = stateParts[i].split("=", 2);
                state = state.withProperty(propertyKeyValue[0], propertyKeyValue[1]);
            }
            return state;
        }
        LinkedHashSet<String> defined = new LinkedHashSet<String>();
        LinkedHashSet<String> needed = new LinkedHashSet<String>(state.getPropertyNames());
        for (int i = 1; i < stateParts.length; ++i) {
            String[] propertyKeyValue = stateParts[i].split("=", 2);
            state = state.withProperty(propertyKeyValue[0], propertyKeyValue[1]);
            defined.add(propertyKeyValue[0]);
        }
        needed.removeAll(defined);
        if (needed.isEmpty()) {
            return state;
        }
        throw new IllegalArgumentException("The state id " + persistedStateId + " is missing the following properties: " + needed);
    }

    private BlockState(@Nonnegative int blockId) {
        Validation.checkPositive("blockId", blockId);
        this.blockId = blockId;
        this.storage = ZERO_STORAGE;
    }

    private BlockState(@Nonnegative int blockId, @Nonnegative byte blockData) {
        Validation.checkPositive("blockId", blockId);
        this.blockId = blockId;
        this.storage = blockData == 0 ? ZERO_STORAGE : new ByteStorage(blockData);
    }

    private BlockState(@Nonnegative int blockId, @Nonnegative int blockData) {
        Validation.checkPositive("blockId", blockId);
        this.blockId = blockId;
        this.storage = blockData == 0 ? ZERO_STORAGE : (blockData <= 127 ? new ByteStorage((byte)blockData) : new IntStorage(blockData));
    }

    private BlockState(@Nonnegative int blockId, @Nonnegative long blockData) {
        Validation.checkPositive("blockId", blockId);
        this.blockId = blockId;
        this.storage = blockData == 0L ? ZERO_STORAGE : (blockData <= 127L ? new ByteStorage((byte)blockData) : (blockData <= Integer.MAX_VALUE ? new IntStorage((int)blockData) : new LongStorage(blockData)));
    }

    private BlockState(@Nonnegative int blockId, @Nonnegative BigInteger blockData) {
        Validation.checkPositive("blockId", blockId);
        this.blockId = blockId;
        int zeroCmp = BigInteger.ZERO.compareTo(blockData);
        this.storage = zeroCmp == 0 ? ZERO_STORAGE : (blockData.compareTo(BYTE_LIMIT) <= 0 ? new ByteStorage(blockData.byteValue()) : (blockData.compareTo(INT_LIMIT) <= 0 ? new IntStorage(blockData.intValue()) : (blockData.compareTo(LONG_LIMIT) <= 0 ? new LongStorage(blockData.longValue()) : new BigIntegerStorage(blockData))));
    }

    @Override
    @Nonnegative
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getBlockId() {
        return this.blockId;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState withData(@Nonnegative int data) {
        return BlockState.of(this.blockId, data);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState withData(@Nonnegative long data) {
        return BlockState.of(this.blockId, data);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState withData(@Nonnegative BigInteger data) {
        return BlockState.of(this.blockId, data);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState withData(@Nonnegative Number data) {
        return BlockState.of(this.blockId, data);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState withBlockId(@Nonnegative int blockId) {
        return this.storage.withBlockId(blockId);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <E extends Serializable> BlockState withProperty(BlockProperty<E> property, @Nullable E value) {
        return this.withProperty(property.getName(), value);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState withProperty(String propertyName, @Nullable Serializable value) {
        return this.storage.withProperty(this.blockId, this.getProperties(), propertyName, value);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState withProperty(String propertyName, String persistenceValue) {
        return this.storage.withPropertyString(this.blockId, this.getProperties(), propertyName, persistenceValue);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState onlyWithProperties(BlockProperty<?> ... properties) {
        String[] names = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            names[i] = properties[i].getName();
        }
        return this.onlyWithProperties(names);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState onlyWithProperties(String ... propertyNames) {
        BlockProperties properties = this.getProperties();
        List<String> list = Arrays.asList(propertyNames);
        if (!properties.getNames().containsAll(list)) {
            LinkedHashSet<String> missing = new LinkedHashSet<String>(list);
            missing.removeAll(properties.getNames());
            throw new NoSuchElementException("Missing properties: " + String.join((CharSequence)", ", missing));
        }
        return this.storage.onlyWithProperties(this, list);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState onlyWithProperty(String name) {
        return this.onlyWithProperties(name);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState onlyWithProperty(BlockProperty<?> property) {
        return this.onlyWithProperties(property);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState onlyWithProperty(String name, Serializable value) {
        return this.storage.onlyWithProperty(this, name, value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T extends Serializable> BlockState onlyWithProperty(BlockProperty<T> property, T value) {
        return this.onlyWithProperty(property.getName(), value);
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockState forItem() {
        BlockProperties allProperties = this.getProperties();
        Set<String> allNames = allProperties.getNames();
        BlockProperties itemProperties = allProperties.getItemBlockProperties();
        List<String> itemNames = itemProperties.getItemPropertyNames();
        if (allNames.size() == itemNames.size() && allNames.containsAll(itemNames)) {
            return this;
        }
        return this.storage.onlyWithProperties(this, itemNames);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public ItemBlock asItemBlock(int count) {
        BlockState trimmedState;
        int itemBlockMeta;
        BlockProperties allProperties = this.getProperties();
        Set<String> allNames = allProperties.getNames();
        BlockProperties itemProperties = allProperties.getItemBlockProperties();
        List<String> itemNames = itemProperties.getItemPropertyNames();
        if (allNames.size() == itemNames.size() && allNames.containsAll(itemNames)) {
            itemBlockMeta = this.getExactIntStorage();
            trimmedState = this;
        } else if (itemNames.isEmpty()) {
            itemBlockMeta = 0;
            trimmedState = this.isDefaultState() ? this : BlockState.of(this.getBlockId());
        } else {
            trimmedState = this.storage.onlyWithProperties(this, itemNames);
            MutableBlockState itemState = itemProperties.createMutableState(this.getBlockId());
            itemNames.forEach(property -> itemState.setPropertyValue((String)property, this.getPropertyValue((String)property)));
            itemBlockMeta = itemState.getExactIntStorage();
        }
        int runtimeId = trimmedState.getRuntimeId();
        if (runtimeId == BlockStateRegistry.getUpdateBlockRegistration() && !"minecraft:info_update".equals(trimmedState.getPersistenceName())) {
            throw new UnknownRuntimeIdException("The current block state can't be represented as an item. State: " + trimmedState + ", Trimmed: " + trimmedState + " ItemBlockMeta: " + itemBlockMeta);
        }
        Block block = trimmedState.getBlock();
        return new ItemBlock(block, (Integer)itemBlockMeta, count);
    }

    @Override
    @Nonnegative
    @Nonnull
    @PowerNukkitOnly
    public Number getDataStorage() {
        return this.storage.getNumber();
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return BlockStateRegistry.getProperties(this.blockId);
    }

    @Override
    @Nonnegative
    @Deprecated
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    @PowerNukkitOnly
    public int getLegacyDamage() {
        return this.storage.getLegacyDamage();
    }

    @Override
    @Deprecated
    @Unsigned
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    @PowerNukkitOnly
    public int getBigDamage() {
        return this.storage.getBigDamage();
    }

    @Override
    @Nonnegative
    @Deprecated
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getSignedBigDamage() {
        return this.storage.getSignedBigDamage();
    }

    @Override
    @Nonnegative
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger getHugeDamage() {
        return this.storage.getHugeDamage();
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public Serializable getPropertyValue(String propertyName) {
        return this.storage.getPropertyValue(this.getProperties(), propertyName);
    }

    @Override
    @PowerNukkitOnly
    public int getIntValue(String propertyName) {
        return this.storage.getIntValue(this.getProperties(), propertyName);
    }

    @Override
    @PowerNukkitOnly
    public boolean getBooleanValue(String propertyName) {
        return this.storage.getBooleanValue(this.getProperties(), propertyName);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public String getPersistenceValue(String propertyName) {
        return this.storage.getPersistenceValue(this.getProperties(), propertyName);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public BlockState getCurrentState() {
        return this;
    }

    @Override
    @PowerNukkitOnly
    public int getBitSize() {
        return this.storage.getBitSize();
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getExactIntStorage() {
        Class<?> storageClass = this.storage.getClass();
        if (this.getBitSize() >= 32 || storageClass != ZeroStorage.class && storageClass != ByteStorage.class && storageClass != IntStorage.class) {
            throw new ArithmeticException(this.getDataStorage() + " cant be stored in a signed 32 bits integer without losses. It has " + this.getBitSize() + " bits");
        }
        return this.getSignedBigDamage();
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultState() {
        return this.storage.isDefaultState();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockState that = (BlockState)o;
        if (this.blockId != that.blockId) {
            return false;
        }
        if (this.storage.getBitSize() != that.storage.getBitSize()) {
            return false;
        }
        return BlockState.compareDataEquality(this.storage.getNumber(), that.storage.getNumber());
    }

    public int hashCode() {
        int bitSize = this.storage.getBitSize();
        int result = this.blockId;
        result = 31 * result + bitSize;
        result = bitSize <= 32 ? 31 * result + this.storage.getBigDamage() : (bitSize <= 64 ? 31 * result + Long.hashCode(this.storage.getNumber().longValue()) : 31 * result + this.storage.getHugeDamage().hashCode());
        return result;
    }

    private static boolean compareDataEquality(Number a, Number b) {
        Class<?> bClass;
        Class<?> aClass = a.getClass();
        if (aClass == (bClass = b.getClass())) {
            return a.equals(b);
        }
        if (aClass != BigInteger.class && bClass != BigInteger.class) {
            return a.longValue() == b.longValue();
        }
        BigInteger aBig = aClass == BigInteger.class ? (BigInteger)a : new BigInteger(a.toString());
        BigInteger bBig = bClass == BigInteger.class ? (BigInteger)b : new BigInteger(b.toString());
        return aBig.equals(bBig);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void validate() {
        if (this.valid == OptionalBoolean.TRUE) {
            return;
        }
        BlockProperties properties = this.getProperties();
        if (this.storage.getBitSize() > properties.getBitSize()) {
            throw new InvalidBlockStateException(this, "The stored data overflows the maximum properties bits. Stored bits: " + this.storage.getBitSize() + ", Properties Bits: " + properties.getBitSize() + ", Stored data: " + this.storage.getNumber());
        }
        try {
            this.storage.validate(properties);
            this.valid = OptionalBoolean.TRUE;
        }
        catch (Exception e) {
            this.valid = OptionalBoolean.FALSE;
            throw new InvalidBlockStateException(this, (Throwable)e);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isCachedValidationValid() {
        return this.valid.orElse(false);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public OptionalBoolean getCachedValidation() {
        return this.valid;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public Block getBlock() {
        try {
            Block block = IBlockState.super.getBlock();
            this.valid = OptionalBoolean.TRUE;
            return block;
        }
        catch (InvalidBlockStateException e) {
            this.valid = OptionalBoolean.FALSE;
            throw e;
        }
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public Block getBlock(@Nullable Level level, int x, int y, int z, int layer, boolean repair, @Nullable Consumer<BlockStateRepair> callback) {
        if (this.valid == OptionalBoolean.TRUE) {
            Block block = IBlockState.super.getBlock();
            block.x = x;
            block.y = y;
            block.z = z;
            block.layer = layer;
            block.level = level;
            return block;
        }
        if (this.valid == OptionalBoolean.FALSE) {
            return IBlockState.super.getBlock(level, x, y, z, layer, repair, callback);
        }
        Consumer<BlockStateRepair> updater = r -> {
            this.valid = OptionalBoolean.FALSE;
        };
        callback = repair && callback != null ? updater.andThen(callback) : updater.andThen(rep -> {
            throw new InvalidBlockStateException(this, "Attempted to repair when repair was false. " + rep.toString(), rep.getValidationException());
        });
        try {
            Block block = IBlockState.super.getBlock(level, x, y, z, layer, true, callback);
            if (this.valid == OptionalBoolean.EMPTY) {
                this.valid = OptionalBoolean.TRUE;
            }
            return block;
        }
        catch (InvalidBlockStateException e) {
            this.valid = OptionalBoolean.FALSE;
            throw e;
        }
    }

    @Generated
    public String toString() {
        return "BlockState(blockId=" + this.getBlockId() + ", storage=" + this.storage + ")";
    }

    @ParametersAreNonnullByDefault
    private class BigIntegerStorage
    implements Storage {
        private static final long serialVersionUID = 2504213066240296662L;
        private final BigInteger data;
        private final int bitSize;

        public BigIntegerStorage(BigInteger data) {
            this.data = data;
            this.bitSize = NukkitMath.bitLength(data);
        }

        @Override
        @Nonnull
        public Number getNumber() {
            return this.getHugeDamage();
        }

        @Override
        public int getLegacyDamage() {
            return this.data.and(BigInteger.valueOf(Block.DATA_MASK)).intValue();
        }

        @Override
        public int getBigDamage() {
            return this.data.and(BigInteger.valueOf(-1L)).intValue();
        }

        @Override
        public int getSignedBigDamage() {
            return this.data.and(BigInteger.valueOf(Integer.MAX_VALUE)).intValue();
        }

        @Override
        @Nonnull
        public Serializable getPropertyValue(BlockProperties properties, String propertyName) {
            return properties.getValue(this.data, propertyName);
        }

        @Override
        public int getIntValue(BlockProperties properties, String propertyName) {
            return properties.getIntValue(this.data, propertyName);
        }

        @Override
        public boolean getBooleanValue(BlockProperties properties, String propertyName) {
            return properties.getBooleanValue(this.data, propertyName);
        }

        @Override
        @Nonnull
        public BlockState withBlockId(int blockId) {
            return BlockState.of(blockId, this.data);
        }

        @Override
        @Nonnull
        public BlockState withProperty(int blockId, BlockProperties properties, String propertyName, @Nullable Serializable value) {
            return BlockState.of(blockId, properties.setValue(this.data, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState withPropertyString(int blockId, BlockProperties properties, String propertyName, String value) {
            return BlockState.of(blockId, properties.setPersistenceValue(this.data, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperties(BlockState currentState, List<String> propertyNames) {
            return BlockState.of(BlockState.this.blockId, BlockState.this.getProperties().reduce(this.data, (property, offset, current) -> propertyNames.contains(property.getName()) ? current : property.setValue((BigInteger)current, (int)offset, null)));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperty(BlockState currentState, String name, Serializable value) {
            return BlockState.of(BlockState.this.blockId, BlockState.this.getProperties().reduce(this.data, (property, offset, current) -> property.setValue((BigInteger)current, (int)offset, name.equals(property.getName()) ? value : null)));
        }

        @Override
        public void validate(BlockProperties properties) {
            properties.forEach((property, offset) -> property.validateMeta(this.data, offset));
        }

        @Override
        public boolean isDefaultState() {
            return this.data.equals(BigInteger.ZERO);
        }

        @Override
        @Nonnull
        public String getPersistenceValue(BlockProperties properties, String propertyName) {
            return properties.getPersistenceValue(this.data, propertyName);
        }

        @Override
        @Nonnull
        public BigInteger getHugeDamage() {
            return this.data;
        }

        public String toString() {
            return this.data.toString();
        }

        @Override
        @Generated
        public int getBitSize() {
            return this.bitSize;
        }
    }

    @ParametersAreNonnullByDefault
    private class LongStorage
    implements Storage {
        private static final long serialVersionUID = -2633333569914851875L;
        private final long data;
        private final int bitSize;

        public LongStorage(long data) {
            this.data = data;
            this.bitSize = NukkitMath.bitLength(data);
        }

        @Override
        @Nonnull
        public Number getNumber() {
            return this.data;
        }

        @Override
        public int getLegacyDamage() {
            return (int)(this.data & (long)Block.DATA_MASK);
        }

        @Override
        public int getBigDamage() {
            return (int)(this.data & 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public int getSignedBigDamage() {
            return (int)(this.data & Integer.MAX_VALUE);
        }

        @Override
        @Nonnull
        public Serializable getPropertyValue(BlockProperties properties, String propertyName) {
            return properties.getValue(this.data, propertyName);
        }

        @Override
        public int getIntValue(BlockProperties properties, String propertyName) {
            return properties.getIntValue(this.data, propertyName);
        }

        @Override
        public boolean getBooleanValue(BlockProperties properties, String propertyName) {
            return properties.getBooleanValue(this.data, propertyName);
        }

        @Override
        @Nonnull
        public BlockState withPropertyString(int blockId, BlockProperties properties, String propertyName, String value) {
            return BlockState.of(blockId, properties.setPersistenceValue(this.data, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState withBlockId(int blockId) {
            return BlockState.of(blockId, this.data);
        }

        @Override
        @Nonnull
        public BlockState withProperty(int blockId, BlockProperties properties, String propertyName, @Nullable Serializable value) {
            return BlockState.of(blockId, properties.setValue(this.data, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperties(BlockState currentState, List<String> propertyNames) {
            return BlockState.of(BlockState.this.blockId, BlockState.this.getProperties().reduceLong(this.data, (property, offset, current) -> propertyNames.contains(property.getName()) ? current : property.setValue(current, offset, null)));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperty(BlockState currentState, String name, Serializable value) {
            return BlockState.of(BlockState.this.blockId, BlockState.this.getProperties().reduceLong(this.data, (property, offset, current) -> property.setValue(current, offset, name.equals(property.getName()) ? value : null)));
        }

        @Override
        public void validate(BlockProperties properties) {
            properties.forEach((property, offset) -> property.validateMeta(this.data, offset));
        }

        @Override
        public boolean isDefaultState() {
            return this.data == 0L;
        }

        @Override
        @Nonnull
        public String getPersistenceValue(BlockProperties properties, String propertyName) {
            return properties.getPersistenceValue(this.data, propertyName);
        }

        @Override
        @Nonnull
        public BigInteger getHugeDamage() {
            return BigInteger.valueOf(this.data);
        }

        public String toString() {
            return Long.toString(this.data);
        }

        @Override
        @Generated
        public int getBitSize() {
            return this.bitSize;
        }
    }

    @ParametersAreNonnullByDefault
    private class IntStorage
    implements Storage {
        private static final long serialVersionUID = 4700387399339051513L;
        private final int data;
        private final int bitSize;

        public IntStorage(int data) {
            this.data = data;
            this.bitSize = NukkitMath.bitLength(data);
        }

        @Override
        @Nonnull
        public Number getNumber() {
            return this.getBigDamage();
        }

        @Override
        public int getLegacyDamage() {
            return this.data & Block.DATA_MASK;
        }

        @Override
        public int getBigDamage() {
            return this.data;
        }

        @Override
        @Nonnull
        public Serializable getPropertyValue(BlockProperties properties, String propertyName) {
            return properties.getValue(this.data, propertyName);
        }

        @Override
        public int getIntValue(BlockProperties properties, String propertyName) {
            return properties.getIntValue(this.data, propertyName);
        }

        @Override
        public boolean getBooleanValue(BlockProperties properties, String propertyName) {
            return properties.getBooleanValue(this.data, propertyName);
        }

        @Override
        @Nonnull
        public BlockState withBlockId(int blockId) {
            return BlockState.of(blockId, this.data);
        }

        @Override
        @Nonnull
        public BlockState withProperty(int blockId, BlockProperties properties, String propertyName, @Nullable Serializable value) {
            return BlockState.of(blockId, properties.setValue(this.data, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState withPropertyString(int blockId, BlockProperties properties, String propertyName, String value) {
            return BlockState.of(blockId, properties.setPersistenceValue(this.data, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperties(BlockState currentState, List<String> propertyNames) {
            return BlockState.of(BlockState.this.blockId, BlockState.this.getProperties().reduceInt(this.data, (property, offset, current) -> propertyNames.contains(property.getName()) ? current : property.setValue(current, offset, null)));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperty(BlockState currentState, String name, Serializable value) {
            return BlockState.of(BlockState.this.blockId, BlockState.this.getProperties().reduceInt(this.data, (property, offset, current) -> property.setValue(current, offset, name.equals(property.getName()) ? value : null)));
        }

        @Override
        public void validate(BlockProperties properties) {
            properties.forEach((property, offset) -> property.validateMeta(this.data, offset));
        }

        @Override
        public boolean isDefaultState() {
            return this.data == 0;
        }

        @Override
        @Nonnull
        public String getPersistenceValue(BlockProperties properties, String propertyName) {
            return properties.getPersistenceValue(this.data, propertyName);
        }

        @Override
        @Nonnull
        public BigInteger getHugeDamage() {
            return BigInteger.valueOf(this.data);
        }

        public String toString() {
            return Integer.toString(this.data);
        }

        @Override
        @Generated
        public int getBitSize() {
            return this.bitSize;
        }
    }

    private class ByteStorage
    implements Storage {
        private final byte data;
        private final int bitSize;

        public ByteStorage(byte data) {
            this.data = data;
            this.bitSize = NukkitMath.bitLength(data);
        }

        @Override
        @Nonnull
        public Number getNumber() {
            return this.data;
        }

        @Override
        public int getLegacyDamage() {
            return this.data & Block.DATA_MASK;
        }

        @Override
        public int getBigDamage() {
            return this.data;
        }

        @Override
        @Nonnull
        public BigInteger getHugeDamage() {
            return BigInteger.valueOf(this.data);
        }

        @Override
        @Nonnull
        public Serializable getPropertyValue(BlockProperties properties, String propertyName) {
            return properties.getValue(this.data, propertyName);
        }

        @Override
        public int getIntValue(BlockProperties properties, String propertyName) {
            return properties.getIntValue(this.data, propertyName);
        }

        @Override
        public boolean getBooleanValue(BlockProperties properties, String propertyName) {
            return properties.getBooleanValue(this.data, propertyName);
        }

        @Override
        @Nonnull
        public BlockState withBlockId(int blockId) {
            return BlockState.of(blockId, this.data);
        }

        @Override
        @Nonnull
        public BlockState withProperty(int blockId, BlockProperties properties, String propertyName, @Nullable Serializable value) {
            return BlockState.of(blockId, properties.setValue(this.data, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState withPropertyString(int blockId, BlockProperties properties, String propertyName, String value) {
            return BlockState.of(blockId, properties.setPersistenceValue(this.data, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperties(BlockState currentState, List<String> propertyNames) {
            return BlockState.of(BlockState.this.blockId, BlockState.this.getProperties().reduceInt(this.data, (property, offset, current) -> propertyNames.contains(property.getName()) ? current : property.setValue(current, offset, null)));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperty(BlockState currentState, String name, Serializable value) {
            return BlockState.of(BlockState.this.blockId, BlockState.this.getProperties().reduceInt(this.data, (property, offset, current) -> property.setValue(current, offset, name.equals(property.getName()) ? value : null)));
        }

        @Override
        public void validate(BlockProperties properties) {
            properties.forEach((property, offset) -> property.validateMeta(this.data, offset));
        }

        @Override
        public boolean isDefaultState() {
            return this.data == 0;
        }

        @Override
        @Nonnull
        public String getPersistenceValue(BlockProperties properties, String propertyName) {
            return properties.getPersistenceValue(this.data, propertyName);
        }

        public String toString() {
            return Byte.toString(this.data);
        }

        @Override
        @Generated
        public int getBitSize() {
            return this.bitSize;
        }
    }

    @ParametersAreNonnullByDefault
    private static class ZeroStorage
    implements Storage {
        private static final long serialVersionUID = -4199347838375711088L;

        private ZeroStorage() {
        }

        @Override
        public int getBitSize() {
            return 1;
        }

        @Override
        @Nonnull
        public Integer getNumber() {
            return 0;
        }

        @Override
        public int getLegacyDamage() {
            return 0;
        }

        @Override
        public int getBigDamage() {
            return 0;
        }

        @Override
        @Nonnull
        public BigInteger getHugeDamage() {
            return BigInteger.ZERO;
        }

        @Override
        @Nonnull
        public Serializable getPropertyValue(BlockProperties properties, String propertyName) {
            return properties.getValue(0, propertyName);
        }

        @Override
        public int getIntValue(BlockProperties properties, String propertyName) {
            return properties.getIntValue(0, propertyName);
        }

        @Override
        public boolean getBooleanValue(BlockProperties properties, String propertyName) {
            return properties.getBooleanValue(0, propertyName);
        }

        @Override
        @Nonnull
        public BlockState withBlockId(int blockId) {
            return BlockState.of(blockId);
        }

        @Override
        @Nonnull
        public BlockState withProperty(int blockId, BlockProperties properties, String propertyName, @Nullable Serializable value) {
            return BlockState.of(blockId, properties.setValue(0, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState withPropertyString(int blockId, BlockProperties properties, String propertyName, String value) {
            return BlockState.of(blockId, properties.setPersistenceValue(0, propertyName, value));
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperties(BlockState currentState, List<String> propertyNames) {
            return currentState;
        }

        @Override
        @Nonnull
        public BlockState onlyWithProperty(BlockState currentState, String name, Serializable value) {
            BlockProperties properties = currentState.getProperties();
            if (!properties.contains(name)) {
                return currentState;
            }
            return BlockState.of(currentState.blockId, properties.setValue(0, name, value));
        }

        @Override
        public void validate(BlockProperties properties) {
        }

        @Override
        public boolean isDefaultState() {
            return true;
        }

        @Override
        @Nonnull
        public String getPersistenceValue(BlockProperties properties, String propertyName) {
            return properties.getPersistenceValue(0, propertyName);
        }

        public String toString() {
            return "0";
        }
    }

    @ParametersAreNonnullByDefault
    private static interface Storage
    extends Serializable {
        @Nonnull
        public Number getNumber();

        public int getLegacyDamage();

        public int getBigDamage();

        default public int getSignedBigDamage() {
            return this.getBigDamage();
        }

        @Nonnull
        public Serializable getPropertyValue(BlockProperties var1, String var2);

        public int getIntValue(BlockProperties var1, String var2);

        public boolean getBooleanValue(BlockProperties var1, String var2);

        @Nonnull
        public BlockState withBlockId(int var1);

        @Nonnull
        public String getPersistenceValue(BlockProperties var1, String var2);

        public int getBitSize();

        @Nonnull
        public BigInteger getHugeDamage();

        @Nonnull
        public BlockState withProperty(int var1, BlockProperties var2, String var3, @Nullable Serializable var4);

        @Nonnull
        public BlockState onlyWithProperties(BlockState var1, List<String> var2);

        @Nonnull
        public BlockState onlyWithProperty(BlockState var1, String var2, Serializable var3);

        public void validate(BlockProperties var1);

        public boolean isDefaultState();

        @Nonnull
        public BlockState withPropertyString(int var1, BlockProperties var2, String var3, String var4);
    }
}

