/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.command.CommandSender;
import cn.nukkit.lang.TextContainer;
import cn.nukkit.permission.Permissible;
import cn.nukkit.permission.PermissibleBase;
import cn.nukkit.permission.Permission;
import cn.nukkit.permission.PermissionAttachment;
import cn.nukkit.permission.PermissionAttachmentInfo;
import cn.nukkit.permission.ServerOperator;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.utils.TextFormat;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;

@PowerNukkitOnly
public class CapturingCommandSender
implements CommandSender {
    private final StringBuilder captured = new StringBuilder();
    @NonNull
    private String name;
    private boolean isOp;
    @NonNull
    private final Permissible perms;

    @PowerNukkitOnly
    public CapturingCommandSender() {
        this("System");
    }

    @PowerNukkitOnly
    public CapturingCommandSender(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.name = name;
        this.perms = new PermissibleBase(this);
    }

    @PowerNukkitOnly
    public CapturingCommandSender(@NonNull String name, boolean isOp) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.name = name;
        this.isOp = isOp;
        this.perms = new PermissibleBase(this);
    }

    @PowerNukkitOnly
    public CapturingCommandSender(@NonNull String name, boolean isOp, @NonNull Function<ServerOperator, Permissible> permissibleFactory) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (permissibleFactory == null) {
            throw new NullPointerException("permissibleFactory is marked @NonNull but is null");
        }
        this.name = name;
        this.isOp = isOp;
        this.perms = permissibleFactory.apply(this);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @PowerNukkitOnly
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Override
    public boolean isOp() {
        return this.isOp;
    }

    @Override
    public void setOp(boolean op) {
        this.isOp = op;
    }

    @PowerNukkitOnly
    public void resetCapture() {
        this.captured.setLength(0);
    }

    @PowerNukkitOnly
    public synchronized String getRawCapture() {
        return this.captured.toString();
    }

    @PowerNukkitOnly
    public synchronized String getCleanCapture() {
        return TextFormat.clean(this.captured.toString());
    }

    public String toString() {
        return "CapturingCommandSender{name='" + this.name + '\'' + '}';
    }

    @Override
    public synchronized void sendMessage(String message) {
        this.captured.append(message).append('\n');
    }

    @Override
    public void sendMessage(TextContainer message) {
        this.sendMessage(message.toString());
    }

    @Override
    public Server getServer() {
        return Server.getInstance();
    }

    @Override
    public boolean isPlayer() {
        return false;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perms.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission permission) {
        return this.perms.isPermissionSet(permission);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perms.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.perms.hasPermission(permission);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perms.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name) {
        return this.perms.addAttachment(plugin, name);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, Boolean value) {
        return this.perms.addAttachment(plugin, name, value);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perms.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perms.recalculatePermissions();
    }

    @Override
    public Map<String, PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perms.getEffectivePermissions();
    }

    @PowerNukkitOnly
    @Generated
    public CapturingCommandSender(@NonNull String name, boolean isOp, @NonNull Permissible perms) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (perms == null) {
            throw new NullPointerException("perms is marked @NonNull but is null");
        }
        this.name = name;
        this.isOp = isOp;
        this.perms = perms;
    }
}

