/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.EntityNameable;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import javax.annotation.Nonnull;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements EntityNameable only in PowerNukkit")
public abstract class EntityCreature
extends EntityLiving
implements EntityNameable {
    public EntityCreature(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (item.getId() == 421 && !player.isAdventure()) {
            return this.applyNameTag(player, item);
        }
        return false;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final boolean playerApplyNameTag(@Nonnull Player player, @Nonnull Item item) {
        return this.applyNameTag(player, item);
    }

    @Since(value="1.4.0.0-PN")
    protected boolean applyNameTag(@Nonnull Player player, @Nonnull Item item) {
        return EntityNameable.super.playerApplyNameTag(player, item);
    }
}

