/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.item.Item;
import cn.nukkit.math.Vector3;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public interface EntityNameable {
    @PowerNukkitOnly(value="The Entity implementations are not PowerNukkit only")
    public void setNameTag(String var1);

    @PowerNukkitOnly(value="The Entity implementations are not PowerNukkit only")
    public String getNameTag();

    @PowerNukkitOnly(value="The Entity implementations are not PowerNukkit only")
    public void setNameTagVisible(boolean var1);

    @PowerNukkitOnly(value="The Entity implementations are not PowerNukkit only")
    public boolean isNameTagVisible();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isPersistent();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPersistent(boolean var1);

    @PowerNukkitOnly(value="The Entity implementations are not PowerNukkit only")
    default public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (item.getId() == 421 && !player.isSpectator()) {
            return this.playerApplyNameTag(player, item);
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean playerApplyNameTag(@Nonnull Player player, @Nonnull Item item) {
        return this.playerApplyNameTag(player, item, true);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean playerApplyNameTag(@Nonnull Player player, @Nonnull Item item, boolean consume) {
        if (item.hasCustomName()) {
            this.setNameTag(item.getCustomName());
            this.setNameTagVisible(true);
            if (consume && !player.isCreative()) {
                item.decrement(1);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(since="1.4.0.0-PN", reason="New implementation needs a player instance, using this method may allow players to name unexpected entities", by="PowerNukkit", replaceWith="playerApplyNameTag(Player, Item)")
    default public boolean applyNameTag(Item item) {
        if (item.hasCustomName()) {
            this.setNameTag(item.getCustomName());
            this.setNameTagVisible(true);
            return true;
        }
        return false;
    }
}

