/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.data;

import cn.nukkit.api.Since;
import cn.nukkit.nbt.stream.FastByteArrayOutputStream;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.PersonaPiece;
import cn.nukkit.utils.PersonaPieceTint;
import cn.nukkit.utils.SerializedImage;
import cn.nukkit.utils.SkinAnimation;
import com.google.common.base.Preconditions;
import com.nimbusds.jose.shaded.json.JSONObject;
import com.nimbusds.jose.shaded.json.JSONValue;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public class Skin {
    private static final int PIXEL_SIZE = 4;
    public static final int SINGLE_SKIN_SIZE = 8192;
    public static final int DOUBLE_SKIN_SIZE = 16384;
    public static final int SKIN_128_64_SIZE = 32768;
    public static final int SKIN_128_128_SIZE = 65536;
    public static final String GEOMETRY_CUSTOM = Skin.convertLegacyGeometryName("geometry.humanoid.custom");
    public static final String GEOMETRY_CUSTOM_SLIM = Skin.convertLegacyGeometryName("geometry.humanoid.customSlim");
    private final String fullSkinId = UUID.randomUUID().toString();
    private String skinId;
    @Since(value="1.4.0.0-PN")
    private String playFabId = "";
    private String skinResourcePatch = GEOMETRY_CUSTOM;
    private SerializedImage skinData;
    private final List<SkinAnimation> animations = new ArrayList<SkinAnimation>();
    private final List<PersonaPiece> personaPieces = new ArrayList<PersonaPiece>();
    private final List<PersonaPieceTint> tintColors = new ArrayList<PersonaPieceTint>();
    private SerializedImage capeData;
    private String geometryData;
    private String animationData;
    private boolean premium;
    private boolean persona;
    private boolean capeOnClassic;
    private boolean primaryUser = true;
    private String capeId;
    private String skinColor = "#0";
    private String armSize = "wide";
    private boolean trusted = false;
    private String geometryDataEngineVersion = "";

    public boolean isValid() {
        return this.isValidSkin() && this.isValidResourcePatch();
    }

    private boolean isValidSkin() {
        return this.skinId != null && !this.skinId.trim().isEmpty() && this.skinData != null && this.skinData.width >= 64 && this.skinData.height >= 32 && this.skinData.data.length >= 8192;
    }

    private boolean isValidResourcePatch() {
        if (this.skinResourcePatch == null) {
            return false;
        }
        try {
            JSONObject object = (JSONObject)JSONValue.parse((String)this.skinResourcePatch);
            JSONObject geometry = (JSONObject)object.get((Object)"geometry");
            return geometry.containsKey((Object)"default") && geometry.get((Object)"default") instanceof String;
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    public SerializedImage getSkinData() {
        if (this.skinData == null) {
            return SerializedImage.EMPTY;
        }
        return this.skinData;
    }

    public String getSkinId() {
        if (this.skinId == null) {
            this.generateSkinId("Custom");
        }
        return this.skinId;
    }

    public void setSkinId(String skinId) {
        if (skinId == null || skinId.trim().isEmpty()) {
            return;
        }
        this.skinId = skinId;
    }

    public void generateSkinId(String name) {
        byte[] data = Binary.appendBytes(this.getSkinData().data, (byte[][])new byte[][]{this.getSkinResourcePatch().getBytes(StandardCharsets.UTF_8)});
        this.skinId = UUID.nameUUIDFromBytes(data) + "." + name;
    }

    public void setSkinData(byte[] skinData) {
        this.setSkinData(SerializedImage.fromLegacy(skinData));
    }

    public void setSkinData(BufferedImage image) {
        this.setSkinData(Skin.parseBufferedImage(image));
    }

    public void setSkinData(SerializedImage skinData) {
        Objects.requireNonNull(skinData, "skinData");
        this.skinData = skinData;
    }

    public void setSkinResourcePatch(String skinResourcePatch) {
        if (skinResourcePatch == null || skinResourcePatch.trim().isEmpty()) {
            skinResourcePatch = GEOMETRY_CUSTOM;
        }
        this.skinResourcePatch = skinResourcePatch;
    }

    public void setGeometryName(String geometryName) {
        if (geometryName == null || geometryName.trim().isEmpty()) {
            this.skinResourcePatch = GEOMETRY_CUSTOM;
            return;
        }
        this.skinResourcePatch = "{\"geometry\" : {\"default\" : \"" + geometryName + "\"}}";
    }

    public String getSkinResourcePatch() {
        if (this.skinResourcePatch == null) {
            return "";
        }
        return this.skinResourcePatch;
    }

    public SerializedImage getCapeData() {
        if (this.capeData == null) {
            return SerializedImage.EMPTY;
        }
        return this.capeData;
    }

    public String getCapeId() {
        if (this.capeId == null) {
            return "";
        }
        return this.capeId;
    }

    public void setCapeId(String capeId) {
        if (capeId == null || capeId.trim().isEmpty()) {
            capeId = null;
        }
        this.capeId = capeId;
    }

    public void setCapeData(byte[] capeData) {
        Objects.requireNonNull(capeData, "capeData");
        Preconditions.checkArgument((capeData.length == 8192 || capeData.length == 0 ? 1 : 0) != 0, (Object)"Invalid legacy cape");
        this.setCapeData(new SerializedImage(64, 32, capeData));
    }

    public void setCapeData(BufferedImage image) {
        this.setCapeData(Skin.parseBufferedImage(image));
    }

    public void setCapeData(SerializedImage capeData) {
        Objects.requireNonNull(capeData, "capeData");
        this.capeData = capeData;
    }

    public String getGeometryData() {
        if (this.geometryData == null) {
            return "";
        }
        return this.geometryData;
    }

    public void setGeometryData(String geometryData) {
        Preconditions.checkNotNull((Object)geometryData, (Object)"geometryData");
        if (!geometryData.equals(this.geometryData)) {
            this.geometryData = geometryData;
        }
    }

    public String getAnimationData() {
        if (this.animationData == null) {
            return "";
        }
        return this.animationData;
    }

    public void setAnimationData(String animationData) {
        Preconditions.checkNotNull((Object)animationData, (Object)"animationData");
        if (!animationData.equals(this.animationData)) {
            this.animationData = animationData;
        }
    }

    public List<SkinAnimation> getAnimations() {
        return this.animations;
    }

    public List<PersonaPiece> getPersonaPieces() {
        return this.personaPieces;
    }

    public List<PersonaPieceTint> getTintColors() {
        return this.tintColors;
    }

    public boolean isPremium() {
        return this.premium;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public boolean isPersona() {
        return this.persona;
    }

    public void setPersona(boolean persona) {
        this.persona = persona;
    }

    public boolean isCapeOnClassic() {
        return this.capeOnClassic;
    }

    public void setCapeOnClassic(boolean capeOnClassic) {
        this.capeOnClassic = capeOnClassic;
    }

    @Since(value="1.5.2.0-PN")
    public void setPrimaryUser(boolean primaryUser) {
        this.primaryUser = primaryUser;
    }

    @Since(value="1.5.2.0-PN")
    public boolean isPrimaryUser() {
        return this.primaryUser;
    }

    @Since(value="1.5.2.0-PN")
    public void setGeometryDataEngineVersion(String geometryDataEngineVersion) {
        this.geometryDataEngineVersion = geometryDataEngineVersion;
    }

    @Since(value="1.5.2.0-PN")
    public String getGeometryDataEngineVersion() {
        return this.geometryDataEngineVersion;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String getSkinColor() {
        return this.skinColor;
    }

    public void setSkinColor(String skinColor) {
        this.skinColor = skinColor;
    }

    public String getArmSize() {
        return this.armSize;
    }

    public void setArmSize(String armSize) {
        this.armSize = armSize;
    }

    public String getFullSkinId() {
        return this.fullSkinId;
    }

    @Since(value="1.4.0.0-PN")
    public void setPlayFabId(String playFabId) {
        this.playFabId = playFabId;
    }

    @Since(value="1.4.0.0-PN")
    public String getPlayFabId() {
        if (this.persona && (this.playFabId == null || this.playFabId.isEmpty())) {
            try {
                this.playFabId = this.skinId.split("-")[5];
            }
            catch (Exception e) {
                this.playFabId = this.fullSkinId.replace("-", "").substring(16);
            }
        }
        return this.playFabId;
    }

    private static SerializedImage parseBufferedImage(BufferedImage image) {
        FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Color color = new Color(image.getRGB(x, y), true);
                outputStream.write(color.getRed());
                outputStream.write(color.getGreen());
                outputStream.write(color.getBlue());
                outputStream.write(color.getAlpha());
            }
        }
        image.flush();
        return new SerializedImage(image.getWidth(), image.getHeight(), outputStream.toByteArray());
    }

    private static String convertLegacyGeometryName(String geometryName) {
        return "{\"geometry\" : {\"default\" : \"" + geometryName + "\"}}";
    }

    @Generated
    public String toString() {
        return "Skin(fullSkinId=" + this.getFullSkinId() + ", skinId=" + this.getSkinId() + ", playFabId=" + this.getPlayFabId() + ", skinResourcePatch=" + this.getSkinResourcePatch() + ", skinData=" + this.getSkinData() + ", animations=" + this.getAnimations() + ", personaPieces=" + this.getPersonaPieces() + ", tintColors=" + this.getTintColors() + ", capeData=" + this.getCapeData() + ", premium=" + this.isPremium() + ", persona=" + this.isPersona() + ", capeOnClassic=" + this.isCapeOnClassic() + ", primaryUser=" + this.isPrimaryUser() + ", capeId=" + this.getCapeId() + ", skinColor=" + this.getSkinColor() + ", armSize=" + this.getArmSize() + ", trusted=" + this.isTrusted() + ", geometryDataEngineVersion=" + this.getGeometryDataEngineVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Skin)) {
            return false;
        }
        Skin other = (Skin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$skinId = this.getSkinId();
        String other$skinId = other.getSkinId();
        if (this$skinId == null ? other$skinId != null : !this$skinId.equals(other$skinId)) {
            return false;
        }
        String this$playFabId = this.getPlayFabId();
        String other$playFabId = other.getPlayFabId();
        if (this$playFabId == null ? other$playFabId != null : !this$playFabId.equals(other$playFabId)) {
            return false;
        }
        String this$skinResourcePatch = this.getSkinResourcePatch();
        String other$skinResourcePatch = other.getSkinResourcePatch();
        if (this$skinResourcePatch == null ? other$skinResourcePatch != null : !this$skinResourcePatch.equals(other$skinResourcePatch)) {
            return false;
        }
        SerializedImage this$skinData = this.getSkinData();
        SerializedImage other$skinData = other.getSkinData();
        if (this$skinData == null ? other$skinData != null : !((Object)this$skinData).equals(other$skinData)) {
            return false;
        }
        List<SkinAnimation> this$animations = this.getAnimations();
        List<SkinAnimation> other$animations = other.getAnimations();
        if (this$animations == null ? other$animations != null : !((Object)this$animations).equals(other$animations)) {
            return false;
        }
        List<PersonaPiece> this$personaPieces = this.getPersonaPieces();
        List<PersonaPiece> other$personaPieces = other.getPersonaPieces();
        if (this$personaPieces == null ? other$personaPieces != null : !((Object)this$personaPieces).equals(other$personaPieces)) {
            return false;
        }
        List<PersonaPieceTint> this$tintColors = this.getTintColors();
        List<PersonaPieceTint> other$tintColors = other.getTintColors();
        if (this$tintColors == null ? other$tintColors != null : !((Object)this$tintColors).equals(other$tintColors)) {
            return false;
        }
        SerializedImage this$capeData = this.getCapeData();
        SerializedImage other$capeData = other.getCapeData();
        if (this$capeData == null ? other$capeData != null : !((Object)this$capeData).equals(other$capeData)) {
            return false;
        }
        String this$geometryData = this.getGeometryData();
        String other$geometryData = other.getGeometryData();
        if (this$geometryData == null ? other$geometryData != null : !this$geometryData.equals(other$geometryData)) {
            return false;
        }
        String this$animationData = this.getAnimationData();
        String other$animationData = other.getAnimationData();
        if (this$animationData == null ? other$animationData != null : !this$animationData.equals(other$animationData)) {
            return false;
        }
        if (this.isPremium() != other.isPremium()) {
            return false;
        }
        if (this.isPersona() != other.isPersona()) {
            return false;
        }
        if (this.isCapeOnClassic() != other.isCapeOnClassic()) {
            return false;
        }
        if (this.isPrimaryUser() != other.isPrimaryUser()) {
            return false;
        }
        String this$capeId = this.getCapeId();
        String other$capeId = other.getCapeId();
        if (this$capeId == null ? other$capeId != null : !this$capeId.equals(other$capeId)) {
            return false;
        }
        String this$skinColor = this.getSkinColor();
        String other$skinColor = other.getSkinColor();
        if (this$skinColor == null ? other$skinColor != null : !this$skinColor.equals(other$skinColor)) {
            return false;
        }
        String this$armSize = this.getArmSize();
        String other$armSize = other.getArmSize();
        if (this$armSize == null ? other$armSize != null : !this$armSize.equals(other$armSize)) {
            return false;
        }
        String this$geometryDataEngineVersion = this.getGeometryDataEngineVersion();
        String other$geometryDataEngineVersion = other.getGeometryDataEngineVersion();
        return !(this$geometryDataEngineVersion == null ? other$geometryDataEngineVersion != null : !this$geometryDataEngineVersion.equals(other$geometryDataEngineVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Skin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $skinId = this.getSkinId();
        result = result * 59 + ($skinId == null ? 43 : $skinId.hashCode());
        String $playFabId = this.getPlayFabId();
        result = result * 59 + ($playFabId == null ? 43 : $playFabId.hashCode());
        String $skinResourcePatch = this.getSkinResourcePatch();
        result = result * 59 + ($skinResourcePatch == null ? 43 : $skinResourcePatch.hashCode());
        SerializedImage $skinData = this.getSkinData();
        result = result * 59 + ($skinData == null ? 43 : ((Object)$skinData).hashCode());
        List<SkinAnimation> $animations = this.getAnimations();
        result = result * 59 + ($animations == null ? 43 : ((Object)$animations).hashCode());
        List<PersonaPiece> $personaPieces = this.getPersonaPieces();
        result = result * 59 + ($personaPieces == null ? 43 : ((Object)$personaPieces).hashCode());
        List<PersonaPieceTint> $tintColors = this.getTintColors();
        result = result * 59 + ($tintColors == null ? 43 : ((Object)$tintColors).hashCode());
        SerializedImage $capeData = this.getCapeData();
        result = result * 59 + ($capeData == null ? 43 : ((Object)$capeData).hashCode());
        String $geometryData = this.getGeometryData();
        result = result * 59 + ($geometryData == null ? 43 : $geometryData.hashCode());
        String $animationData = this.getAnimationData();
        result = result * 59 + ($animationData == null ? 43 : $animationData.hashCode());
        result = result * 59 + (this.isPremium() ? 79 : 97);
        result = result * 59 + (this.isPersona() ? 79 : 97);
        result = result * 59 + (this.isCapeOnClassic() ? 79 : 97);
        result = result * 59 + (this.isPrimaryUser() ? 79 : 97);
        String $capeId = this.getCapeId();
        result = result * 59 + ($capeId == null ? 43 : $capeId.hashCode());
        String $skinColor = this.getSkinColor();
        result = result * 59 + ($skinColor == null ? 43 : $skinColor.hashCode());
        String $armSize = this.getArmSize();
        result = result * 59 + ($armSize == null ? 43 : $armSize.hashCode());
        String $geometryDataEngineVersion = this.getGeometryDataEngineVersion();
        result = result * 59 + ($geometryDataEngineVersion == null ? 43 : $geometryDataEngineVersion.hashCode());
        return result;
    }
}

