/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.data;

import cn.nukkit.entity.data.EntityData;
import cn.nukkit.math.Vector3f;

public class Vector3fEntityData
extends EntityData<Vector3f> {
    public float x;
    public float y;
    public float z;

    public Vector3fEntityData(int id, float x, float y, float z) {
        super(id);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3fEntityData(int id, Vector3f pos) {
        this(id, pos.x, pos.y, pos.z);
    }

    @Override
    public Vector3f getData() {
        return new Vector3f(this.x, this.y, this.z);
    }

    @Override
    public void setData(Vector3f data) {
        if (data != null) {
            this.x = data.x;
            this.y = data.y;
            this.z = data.z;
        }
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

