/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLava;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.event.entity.EntityBlockChangeEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;

public class EntityFallingBlock
extends Entity {
    public static final int NETWORK_ID = 66;
    protected int blockId;
    protected int damage;
    @PowerNukkitOnly
    protected boolean breakOnLava;

    @Override
    public float getWidth() {
        return 0.98f;
    }

    @Override
    public float getLength() {
        return 0.98f;
    }

    @Override
    public float getHeight() {
        return 0.98f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    protected float getDrag() {
        return 0.02f;
    }

    @Override
    protected float getBaseOffset() {
        return 0.49f;
    }

    @Override
    public boolean canCollide() {
        return this.blockId == 145;
    }

    public EntityFallingBlock(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        if (this.namedTag != null) {
            if (this.namedTag.contains("TileID")) {
                this.blockId = this.namedTag.getInt("TileID");
            } else if (this.namedTag.contains("Tile")) {
                this.blockId = this.namedTag.getInt("Tile");
                this.namedTag.putInt("TileID", this.blockId);
            }
            if (this.namedTag.contains("Data")) {
                this.damage = this.namedTag.getByte("Data");
            }
        }
        this.breakOnLava = this.namedTag.getBoolean("BreakOnLava");
        if (this.blockId == 0) {
            this.close();
            return;
        }
        this.fireProof = true;
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_FIRE_IMMUNE, true);
        this.setDataProperty(new IntEntityData(DATA_VARIANT, GlobalBlockPalette.getOrCreateRuntimeId(this.getBlock(), this.getDamage())));
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return this.blockId == 145;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return source.getCause() == EntityDamageEvent.DamageCause.VOID && super.attack(source);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        boolean hasUpdate;
        block10: {
            block11: {
                block14: {
                    Block block;
                    Vector3 pos;
                    block12: {
                        int mergedHeight;
                        Block floorBlock;
                        Vector3 floorPos;
                        block13: {
                            if (this.closed) {
                                return false;
                            }
                            this.timing.startTiming();
                            int tickDiff = currentTick - this.lastUpdate;
                            if (tickDiff <= 0 && !this.justCreated) {
                                return true;
                            }
                            this.lastUpdate = currentTick;
                            hasUpdate = this.entityBaseTick(tickDiff);
                            if (!this.isAlive()) break block10;
                            this.motionY -= (double)this.getGravity();
                            this.move(this.motionX, this.motionY, this.motionZ);
                            float friction = 1.0f - this.getDrag();
                            this.motionX *= (double)friction;
                            this.motionY *= (double)(1.0f - this.getDrag());
                            this.motionZ *= (double)friction;
                            pos = new Vector3(this.x - 0.5, this.y, this.z - 0.5).round();
                            if (this.breakOnLava && this.level.getBlock(pos.subtract(0.0, 1.0, 0.0)) instanceof BlockLava) {
                                this.close();
                                if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                                    this.getLevel().dropItem(this, Block.get(this.getBlock(), this.getDamage()).toItem());
                                }
                                this.level.addParticle(new DestroyBlockParticle(pos, Block.get(this.getBlock(), this.getDamage())));
                                return true;
                            }
                            if (!this.onGround) break block11;
                            this.close();
                            block = this.level.getBlock(pos);
                            floorPos = new Vector3(this.x - 0.5, this.y, this.z - 0.5).floor();
                            floorBlock = this.level.getBlock(floorPos);
                            if (this.getBlock() != 78 || floorBlock.getId() != 78 || (floorBlock.getDamage() & 7) == 7) break block12;
                            mergedHeight = (floorBlock.getDamage() & 7) + 1 + (this.getDamage() & 7) + 1;
                            if (mergedHeight <= 8) break block13;
                            EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, floorBlock, Block.get(78, 7));
                            this.server.getPluginManager().callEvent(event);
                            if (event.isCancelled()) break block14;
                            this.level.setBlock(floorPos, event.getTo(), true);
                            Vector3 abovePos = floorPos.up();
                            Block aboveBlock = this.level.getBlock(abovePos);
                            if (aboveBlock.getId() != 0) break block14;
                            EntityBlockChangeEvent event2 = new EntityBlockChangeEvent(this, aboveBlock, Block.get(78, mergedHeight - 8 - 1));
                            this.server.getPluginManager().callEvent(event2);
                            if (event2.isCancelled()) break block14;
                            this.level.setBlock(abovePos, event2.getTo(), true);
                            break block14;
                        }
                        EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, floorBlock, Block.get(78, mergedHeight - 1));
                        this.server.getPluginManager().callEvent(event);
                        if (event.isCancelled()) break block14;
                        this.level.setBlock(floorPos, event.getTo(), true);
                        break block14;
                    }
                    if (block.getId() > 0 && block.isTransparent() && !block.canBeReplaced() || this.getBlock() == 78 && block instanceof BlockLiquid) {
                        if (this.getBlock() != 78 ? this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS) : this.level.getGameRules().getBoolean(GameRule.DO_TILE_DROPS)) {
                            this.getLevel().dropItem(this, Block.get(this.getBlock(), this.getDamage()).toItem());
                        }
                    } else {
                        EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, block, Block.get(this.getBlock(), this.getDamage()));
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            this.getLevel().setBlock(pos, event.getTo(), true);
                            if (event.getTo().getId() == 145) {
                                Entity[] e;
                                this.getLevel().addLevelEvent(block, 1022);
                                for (Entity entity : e = this.level.getCollidingEntities(this.getBoundingBox(), this)) {
                                    if (!(entity instanceof EntityLiving) || !(this.fallDistance > 0.0f)) continue;
                                    entity.attack(new EntityDamageByBlockEvent(event.getTo(), entity, EntityDamageEvent.DamageCause.FALLING_BLOCK, Math.min(40.0f, Math.max(0.0f, this.fallDistance * 2.0f))));
                                }
                            }
                        }
                    }
                }
                hasUpdate = true;
            }
            this.updateMovement();
        }
        this.timing.stopTiming();
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    public int getBlock() {
        return this.blockId;
    }

    public int getDamage() {
        return this.damage;
    }

    @Override
    public int getNetworkId() {
        return 66;
    }

    @Override
    public void saveNBT() {
        this.namedTag.putInt("TileID", this.blockId);
        this.namedTag.putByte("Data", this.damage);
    }

    @Override
    public boolean canBeMovedByCurrents() {
        return false;
    }

    @Override
    public void resetFallDistance() {
        if (!this.closed) {
            this.highestPosition = this.y;
        }
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public String getOriginalName() {
        return "Falling Block";
    }
}

