/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.entity.item.EntityEndCrystal;
import cn.nukkit.event.entity.EntityCombustByEntityEvent;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.ProjectileHitEvent;
import cn.nukkit.level.MovingObjectPosition;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public abstract class EntityProjectile
extends Entity {
    public static final int DATA_SHOOTER_ID = 17;
    @Since(value="1.6.0.0-PN")
    public static final int PICKUP_NONE = 0;
    @Since(value="1.6.0.0-PN")
    public static final int PICKUP_ANY = 1;
    @Since(value="1.6.0.0-PN")
    public static final int PICKUP_CREATIVE = 2;
    public Entity shootingEntity;
    private boolean noAge;
    public boolean hadCollision;
    public boolean closeOnCollide;
    @Deprecated
    @DeprecationDetails(since="1.6.0.0-PN", by="PowerNukkit", reason="Redundant and unused", replaceWith="getDamage()")
    protected double damage;

    protected double getDamage() {
        return this.namedTag.contains("damage") ? this.namedTag.getDouble("damage") : this.getBaseDamage();
    }

    protected double getBaseDamage() {
        return 0.0;
    }

    public EntityProjectile(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityProjectile(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt);
        this.shootingEntity = shootingEntity;
        if (shootingEntity != null) {
            this.setDataProperty(new LongEntityData(17, shootingEntity.getId()));
        }
    }

    @PowerNukkitOnly(value="Allows to modify the damage based on the entity being damaged")
    @Since(value="1.4.0.0-PN")
    public int getResultDamage(@Nullable Entity entity) {
        return this.getResultDamage();
    }

    public int getResultDamage() {
        return NukkitMath.ceilDouble(Math.sqrt(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ) * this.getDamage());
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return source.getCause() == EntityDamageEvent.DamageCause.VOID && super.attack(source);
    }

    public void onCollideWithEntity(Entity entity) {
        ProjectileHitEvent projectileHitEvent = new ProjectileHitEvent(this, MovingObjectPosition.fromEntity(entity));
        this.server.getPluginManager().callEvent(projectileHitEvent);
        if (projectileHitEvent.isCancelled()) {
            return;
        }
        float damage = this.getResultDamage(entity);
        EntityDamageByEntityEvent ev = this.shootingEntity == null ? new EntityDamageByEntityEvent((Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage) : new EntityDamageByChildEntityEvent(this.shootingEntity, (Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage);
        if (entity.attack(ev)) {
            this.addHitEffect();
            this.hadCollision = true;
            if (this.fireTicks > 0) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent(this, entity, 5);
                this.server.getPluginManager().callEvent(event);
                if (!event.isCancelled()) {
                    entity.setOnFire(event.getDuration());
                }
            }
        }
        this.afterCollisionWithEntity(entity);
        if (this.closeOnCollide) {
            this.close();
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected void afterCollisionWithEntity(Entity entity) {
    }

    @Override
    protected void initEntity() {
        this.closeOnCollide = true;
        super.initEntity();
        this.setMaxHealth(1);
        this.setHealth(1.0f);
        if (this.namedTag.contains("Age") && !this.noAge) {
            this.age = this.namedTag.getShort("Age");
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return (entity instanceof EntityLiving || entity instanceof EntityEndCrystal) && !this.onGround;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        if (!this.noAge) {
            this.namedTag.putShort("Age", this.age);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected void updateMotion() {
        this.motionY -= (double)this.getGravity();
        this.motionX *= (double)(1.0f - this.getDrag());
        this.motionZ *= (double)(1.0f - this.getDrag());
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            MovingObjectPosition movingObjectPosition = null;
            if (!this.isCollided) {
                this.updateMotion();
            }
            Vector3 moveVector = new Vector3(this.x + this.motionX, this.y + this.motionY, this.z + this.motionZ);
            Entity[] list = this.getLevel().getCollidingEntities(this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0), this);
            double nearDistance = 2.147483647E9;
            Entity nearEntity = null;
            for (Entity entity : list) {
                double distance;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition ob;
                if (entity == this.shootingEntity && this.ticksLived < 5 || entity instanceof Player && ((Player)entity).getGamemode() == 3 || (ob = (axisalignedbb = entity.boundingBox.grow(0.3, 0.3, 0.3)).calculateIntercept(this, moveVector)) == null || !((distance = this.distanceSquared(ob.hitVector)) < nearDistance)) continue;
                nearDistance = distance;
                nearEntity = entity;
            }
            if (nearEntity != null) {
                movingObjectPosition = MovingObjectPosition.fromEntity(nearEntity);
            }
            if (movingObjectPosition != null && movingObjectPosition.entityHit != null) {
                this.onCollideWithEntity(movingObjectPosition.entityHit);
                hasUpdate = true;
                if (this.closed) {
                    return true;
                }
            }
            Position position = this.getPosition();
            Vector3 motion = this.getMotion();
            this.move(this.motionX, this.motionY, this.motionZ);
            if (this.isCollided && !this.hadCollision) {
                this.hadCollision = true;
                this.motionX = 0.0;
                this.motionY = 0.0;
                this.motionZ = 0.0;
                this.server.getPluginManager().callEvent(new ProjectileHitEvent(this, MovingObjectPosition.fromBlock(this.getFloorX(), this.getFloorY(), this.getFloorZ(), -1, (Vector3)this)));
                this.onCollideWithBlock(position, motion);
                this.addHitEffect();
                return false;
            }
            if (!this.isCollided && this.hadCollision) {
                this.hadCollision = false;
            }
            if (!this.hadCollision || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5) {
                this.updateRotation();
                hasUpdate = true;
            }
            this.updateMovement();
        }
        return hasUpdate;
    }

    @PowerNukkitOnly
    public void updateRotation() {
        double f = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.yaw = Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI;
        this.pitch = Math.atan2(this.motionY, f) * 180.0 / Math.PI;
    }

    @PowerNukkitOnly
    public void inaccurate(float modifier) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        this.motionX += rand.nextGaussian() * (double)0.0075f * (double)modifier;
        this.motionY += rand.nextGaussian() * (double)0.0075f * (double)modifier;
        this.motionZ += rand.nextGaussian() * (double)0.0075f * (double)modifier;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected void onCollideWithBlock(Position position, Vector3 motion) {
        for (Block collisionBlock : this.level.getCollisionBlocks(this.getBoundingBox().grow(0.1, 0.1, 0.1))) {
            this.onCollideWithBlock(position, motion, collisionBlock);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean onCollideWithBlock(Position position, Vector3 motion, Block collisionBlock) {
        return collisionBlock.onProjectileHit(this, position, motion);
    }

    @PowerNukkitOnly
    protected void addHitEffect() {
    }

    @Deprecated
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    @DeprecationDetails(by="PowerNukkit", since="1.6.0.0-PN", reason="Bad method name", replaceWith="getHasAge", toBeRemovedAt="1.7.0.0-PN")
    public boolean hasAge() {
        return this.getHasAge();
    }

    @Deprecated
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    @DeprecationDetails(by="PowerNukkit", since="1.6.0.0-PN", reason="Bad method name", replaceWith="setHasAge", toBeRemovedAt="1.7.0.0-PN")
    public void setAge(boolean hasAge) {
        this.setHasAge(hasAge);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setHasAge(boolean hasAge) {
        this.noAge = !hasAge;
    }

    public boolean getHasAge() {
        return !this.noAge;
    }
}

