/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.entity.weather.EntityLightning;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.ProjectileHitEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.MovingObjectPosition;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.AddEntityPacket;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class EntityThrownTrident
extends EntityProjectile {
    public static final int NETWORK_ID = 73;
    private static final String TAG_PICKUP = "pickup";
    private static final String TAG_TRIDENT = "Trident";
    private static final String TAG_FAVORED_SLOT = "favoredSlot";
    private static final String TAG_CREATIVE = "isCreative";
    private static final String TAG_PLAYER = "player";
    private static final String NAME_TRIDENT = "Trident";
    protected Item trident;
    private Vector3 collisionPos;
    private BlockVector3 stuckToBlockPos;
    private int favoredSlot;
    private boolean player;
    private int loyaltyLevel;
    private boolean hasChanneling;
    private int riptideLevel;
    private int impalingLevel;
    @PowerNukkitOnly
    protected float gravity = 0.04f;
    @PowerNukkitOnly
    protected float drag = 0.01f;
    private static final Vector3 defaultCollisionPos = new Vector3(0.0, 0.0, 0.0);
    private static final BlockVector3 defaultStuckToBlockPos = new BlockVector3(0, 0, 0);
    @Since(value="1.6.0.0-PN")
    protected int pickupMode;
    @Since(value="1.6.0.0-PN")
    public boolean alreadyCollided;

    @Override
    public int getNetworkId() {
        return 73;
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getLength() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.35f;
    }

    @Override
    public float getGravity() {
        return 0.05f;
    }

    @Override
    public float getDrag() {
        return 0.01f;
    }

    public EntityThrownTrident(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityThrownTrident(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt, shootingEntity);
    }

    @Deprecated
    public EntityThrownTrident(FullChunk chunk, CompoundTag nbt, Entity shootingEntity, boolean critical) {
        this(chunk, nbt, shootingEntity);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public String getOriginalName() {
        return "Trident";
    }

    @Override
    protected void initEntity() {
        super.setHasAge(false);
        super.initEntity();
        this.closeOnCollide = false;
        this.pickupMode = this.namedTag.contains(TAG_PICKUP) ? this.namedTag.getByte(TAG_PICKUP) : 1;
        this.damage = this.namedTag.contains("damage") ? this.namedTag.getDouble("damage") : 8.0;
        this.favoredSlot = this.namedTag.contains(TAG_FAVORED_SLOT) ? this.namedTag.getInt(TAG_FAVORED_SLOT) : -1;
        boolean bl = this.player = !this.namedTag.contains(TAG_PLAYER) || this.namedTag.getBoolean(TAG_PLAYER);
        if (this.namedTag.contains(TAG_CREATIVE)) {
            if (this.pickupMode == 1 && this.namedTag.getBoolean(TAG_CREATIVE)) {
                this.pickupMode = 2;
            }
            this.namedTag.remove(TAG_CREATIVE);
        }
        if (this.namedTag.contains("Trident")) {
            this.trident = NBTIO.getItemHelper(this.namedTag.getCompound("Trident"));
            this.loyaltyLevel = this.trident.getEnchantmentLevel(31);
            this.hasChanneling = this.trident.hasEnchantment(32);
            this.riptideLevel = this.trident.getEnchantmentLevel(30);
            this.impalingLevel = this.trident.getEnchantmentLevel(29);
        } else {
            this.trident = Item.get(0);
            this.loyaltyLevel = 0;
            this.hasChanneling = false;
            this.riptideLevel = 0;
            this.impalingLevel = 0;
        }
        if (this.namedTag.contains("CollisionPos")) {
            ListTag<DoubleTag> collisionPosList = this.namedTag.getList("CollisionPos", DoubleTag.class);
            this.collisionPos = new Vector3(collisionPosList.get((int)0).data, collisionPosList.get((int)1).data, collisionPosList.get((int)2).data);
        } else {
            this.collisionPos = defaultCollisionPos.clone();
        }
        if (this.namedTag.contains("StuckToBlockPos")) {
            ListTag<IntTag> stuckToBlockPosList = this.namedTag.getList("StuckToBlockPos", IntTag.class);
            this.stuckToBlockPos = new BlockVector3(stuckToBlockPosList.get((int)0).data, stuckToBlockPosList.get((int)1).data, stuckToBlockPosList.get((int)2).data);
        } else {
            this.stuckToBlockPos = defaultStuckToBlockPos.clone();
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.put("Trident", NBTIO.putItemHelper(this.trident));
        this.namedTag.putByte(TAG_PICKUP, this.pickupMode);
        this.namedTag.putList(new ListTag<DoubleTag>("CollisionPos").add(new DoubleTag("0", this.collisionPos.x)).add(new DoubleTag("1", this.collisionPos.y)).add(new DoubleTag("2", this.collisionPos.z)));
        this.namedTag.putList(new ListTag<IntTag>("StuckToBlockPos").add(new IntTag("0", this.stuckToBlockPos.x)).add(new IntTag("1", this.stuckToBlockPos.y)).add(new IntTag("2", this.stuckToBlockPos.z)));
        this.namedTag.putInt(TAG_FAVORED_SLOT, this.favoredSlot);
        this.namedTag.putBoolean(TAG_PLAYER, this.player);
    }

    public Item getItem() {
        return this.trident != null ? this.trident.clone() : Item.get(0);
    }

    public void setItem(Item item) {
        this.trident = item.clone();
        this.loyaltyLevel = this.trident.getEnchantmentLevel(31);
        this.hasChanneling = this.trident.hasEnchantment(32);
        this.riptideLevel = this.trident.getEnchantmentLevel(30);
        this.impalingLevel = this.trident.getEnchantmentLevel(29);
    }

    @PowerNukkitOnly
    public void setCritical() {
        this.setCritical(true);
    }

    @PowerNukkitOnly
    public void setCritical(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_CRITICAL, value);
    }

    @PowerNukkitOnly
    public boolean isCritical() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_CRITICAL);
    }

    @Override
    public int getResultDamage() {
        int base = super.getResultDamage();
        if (this.isCritical()) {
            base += ThreadLocalRandom.current().nextInt(base / 2 + 2);
        }
        return base;
    }

    @Override
    protected double getBaseDamage() {
        return 8.0;
    }

    @Override
    @PowerNukkitDifference(info="Using new method to play sounds", since="1.4.0.0-PN")
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        if (this.isCollided && !this.hadCollision) {
            this.getLevel().addSound(this, Sound.ITEM_TRIDENT_HIT_GROUND);
        }
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.onGround || this.hadCollision) {
            this.setCritical(false);
        }
        if (this.noClip) {
            if (this.canReturnToShooter()) {
                Entity shooter = this.shootingEntity;
                Vector3 vector3 = new Vector3(shooter.x - this.x, shooter.y + (double)shooter.getEyeHeight() - this.y, shooter.z - this.z);
                this.setPosition(new Vector3(this.x, this.y + vector3.y * 0.015 * (double)this.loyaltyLevel, this.z));
                this.setMotion(this.getMotion().multiply(0.95).add(vector3.multiply((double)this.loyaltyLevel * 0.05)));
                hasUpdate = true;
            } else {
                if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS) && !this.closed) {
                    this.level.dropItem(this, this.trident);
                }
                this.close();
            }
        }
        this.timing.stopTiming();
        return hasUpdate;
    }

    @Override
    public void spawnTo(Player player) {
        AddEntityPacket pk = new AddEntityPacket();
        pk.type = 73;
        pk.entityUniqueId = this.getId();
        pk.entityRuntimeId = this.getId();
        pk.x = (float)this.x;
        pk.y = (float)this.y;
        pk.z = (float)this.z;
        pk.speedX = (float)this.motionX;
        pk.speedY = (float)this.motionY;
        pk.speedZ = (float)this.motionZ;
        pk.yaw = (float)this.yaw;
        pk.pitch = (float)this.pitch;
        pk.metadata = this.dataProperties;
        player.dataPacket(pk);
        super.spawnTo(player);
    }

    @Override
    @PowerNukkitDifference(info="Using new method to play sounds", since="1.4.0.0-PN")
    public void onCollideWithEntity(Entity entity) {
        if (this.noClip) {
            return;
        }
        if (this.alreadyCollided) {
            this.move(this.motionX, this.motionY, this.motionZ);
            return;
        }
        this.server.getPluginManager().callEvent(new ProjectileHitEvent(this, MovingObjectPosition.fromEntity(entity)));
        float damage = this.getResultDamage();
        if (this.impalingLevel > 0 && (entity.isTouchingWater() || entity.getLevel().isRaining() && entity.getLevel().canBlockSeeSky(entity))) {
            damage += 2.5f * (float)this.impalingLevel;
        }
        EntityDamageByEntityEvent ev = this.shootingEntity == null ? new EntityDamageByEntityEvent((Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage) : new EntityDamageByChildEntityEvent(this.shootingEntity, (Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage);
        entity.attack(ev);
        this.getLevel().addSound(this, Sound.ITEM_TRIDENT_HIT);
        this.hadCollision = true;
        this.setCollisionPos(this);
        this.setMotion(new Vector3(this.getMotion().getX() * -0.01, this.getMotion().getY() * -0.1, this.getMotion().getZ() * -0.01));
        if (this.hasChanneling && this.level.isThundering() && this.level.canBlockSeeSky(this)) {
            Position pos = this.getPosition();
            EntityLightning lighting = new EntityLightning(pos.getChunk(), EntityThrownTrident.getDefaultNBT(pos));
            lighting.spawnToAll();
            this.getLevel().addSound(this, Sound.ITEM_TRIDENT_THUNDER);
        }
        if (this.canReturnToShooter()) {
            this.getLevel().addSound(this, Sound.ITEM_TRIDENT_RETURN);
            this.setNoClip(true);
            this.hadCollision = false;
            this.setTridentRope(true);
        }
    }

    @PowerNukkitOnly
    public Entity create(Object type, Position source, Object ... args) {
        BaseFullChunk chunk = source.getLevel().getChunk((int)source.x >> 4, (int)source.z >> 4);
        if (chunk == null) {
            return null;
        }
        CompoundTag nbt = Entity.getDefaultNBT(source.add(0.5, 0.0, 0.5), null, new Random().nextFloat() * 360.0f, 0.0f);
        return Entity.createEntity(type.toString(), (FullChunk)chunk, nbt, args);
    }

    @Since(value="1.6.0.0-PN")
    public int getPickupMode() {
        return this.pickupMode;
    }

    @Since(value="1.6.0.0-PN")
    public void setPickupMode(int pickupMode) {
        this.pickupMode = pickupMode;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected void onCollideWithBlock(Position position, Vector3 motion) {
        if (this.noClip) {
            return;
        }
        for (Block collisionBlock : this.level.getCollisionBlocks(this.getBoundingBox().grow(0.1, 0.1, 0.1))) {
            this.setStuckToBlockPos(new BlockVector3(collisionBlock.getFloorX(), collisionBlock.getFloorY(), collisionBlock.getFloorZ()));
            if (this.canReturnToShooter()) {
                this.getLevel().addSound(this, Sound.ITEM_TRIDENT_RETURN);
                this.setNoClip(true);
                this.setTridentRope(true);
                return;
            }
            this.onCollideWithBlock(position, motion, collisionBlock);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Vector3 getCollisionPos() {
        return this.collisionPos;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setCollisionPos(Vector3 collisionPos) {
        this.collisionPos = collisionPos;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockVector3 getStuckToBlockPos() {
        return this.stuckToBlockPos;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setStuckToBlockPos(BlockVector3 stuckToBlockPos) {
        this.stuckToBlockPos = stuckToBlockPos;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getFavoredSlot() {
        return this.favoredSlot;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setFavoredSlot(int favoredSlot) {
        this.favoredSlot = favoredSlot;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isCreative() {
        return this.getPickupMode() == 2;
    }

    @Deprecated
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    @DeprecationDetails(since="1.6.0.0-PN", by="PowerNukkit", replaceWith="setPickupMode(EntityProjectile.PICKUP_<MODE>)", reason="Nukkit added this API in 3-states, NONE, ANY, and CREATIVE")
    public void setCreative(boolean isCreative) {
        if (isCreative) {
            this.setPickupMode(2);
        } else if (this.getPickupMode() == 2) {
            this.setPickupMode(1);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isPlayer() {
        return this.player;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPlayer(boolean player) {
        this.player = player;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getLoyaltyLevel() {
        return this.loyaltyLevel;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setLoyaltyLevel(int loyaltyLevel) {
        this.loyaltyLevel = loyaltyLevel;
        if (loyaltyLevel > 0) {
            this.trident.addEnchantment(Enchantment.getEnchantment(31).setLevel(loyaltyLevel));
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean hasChanneling() {
        return this.hasChanneling;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setChanneling(boolean hasChanneling) {
        this.hasChanneling = hasChanneling;
        if (hasChanneling) {
            this.trident.addEnchantment(Enchantment.getEnchantment(32));
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getRiptideLevel() {
        return this.riptideLevel;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setRiptideLevel(int riptideLevel) {
        this.riptideLevel = riptideLevel;
        if (riptideLevel > 0) {
            this.trident.addEnchantment(Enchantment.getEnchantment(30).setLevel(riptideLevel));
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getImpalingLevel() {
        return this.impalingLevel;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setImpalingLevel(int impalingLevel) {
        this.impalingLevel = impalingLevel;
        if (impalingLevel > 0) {
            this.trident.addEnchantment(Enchantment.getEnchantment(29).setLevel(impalingLevel));
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getTridentRope() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_SHOW_TRIDENT_ROPE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTridentRope(boolean tridentRope) {
        if (tridentRope) {
            this.setDataProperty(new LongEntityData(DATA_OWNER_EID, this.shootingEntity.getId()));
        } else {
            this.setDataProperty(new LongEntityData(DATA_OWNER_EID, -1L));
        }
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_SHOW_TRIDENT_ROPE, tridentRope);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean canReturnToShooter() {
        Entity shooter;
        if (this.loyaltyLevel <= 0) {
            return false;
        }
        if (this.getCollisionPos().equals(defaultCollisionPos)) {
            if (this.getStuckToBlockPos().equals(defaultStuckToBlockPos)) {
                return false;
            }
        }
        if ((shooter = this.shootingEntity) != null && shooter.isAlive() && shooter instanceof Player) {
            return !((Player)shooter).isSpectator();
        }
        return false;
    }
}

