/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.entity;

import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.enchantment.Enchantment;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityDamageByEntityEvent
extends EntityDamageEvent {
    @Nonnull
    private final Entity damager;
    private float knockBack;
    @Nullable
    private Enchantment[] enchantments;

    public EntityDamageByEntityEvent(@Nonnull Entity damager, @Nonnull Entity entity, @Nonnull EntityDamageEvent.DamageCause cause, float damage) {
        this(damager, entity, cause, damage, 0.3f);
    }

    public EntityDamageByEntityEvent(@Nonnull Entity damager, @Nonnull Entity entity, @Nonnull EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Float> modifiers) {
        this(damager, entity, cause, modifiers, 0.3f);
    }

    public EntityDamageByEntityEvent(@Nonnull Entity damager, @Nonnull Entity entity, @Nonnull EntityDamageEvent.DamageCause cause, float damage, float knockBack) {
        super(entity, cause, damage);
        this.damager = damager;
        this.knockBack = knockBack;
        this.addAttackerModifiers(damager);
    }

    public EntityDamageByEntityEvent(@Nonnull Entity damager, @Nonnull Entity entity, @Nonnull EntityDamageEvent.DamageCause cause, @Nonnull Map<EntityDamageEvent.DamageModifier, Float> modifiers, float knockBack) {
        this(damager, entity, cause, modifiers, knockBack, null);
    }

    @Since(value="1.6.0.0-PN")
    public EntityDamageByEntityEvent(@Nonnull Entity damager, @Nonnull Entity entity, @Nonnull EntityDamageEvent.DamageCause cause, @Nonnull Map<EntityDamageEvent.DamageModifier, Float> modifiers, float knockBack, @Nullable Enchantment[] enchantments) {
        super(entity, cause, modifiers);
        if (enchantments != null) {
            for (Enchantment enchantment : enchantments = enchantments.length == 0 ? Enchantment.EMPTY_ARRAY : (Enchantment[])enchantments.clone()) {
                if (enchantment == null) continue;
                this.addSideEffects(enchantment.getAttackSideEffects(damager, entity));
            }
        }
        this.damager = damager;
        this.knockBack = knockBack;
        this.enchantments = enchantments;
        this.addAttackerModifiers(damager);
    }

    protected void addAttackerModifiers(Entity damager) {
        if (damager.hasEffect(5)) {
            this.setDamage((float)((double)this.getDamage(EntityDamageEvent.DamageModifier.BASE) * 0.3 * (double)(damager.getEffect(5).getAmplifier() + 1)), EntityDamageEvent.DamageModifier.STRENGTH);
        }
        if (damager.hasEffect(18)) {
            this.setDamage(-((float)((double)this.getDamage(EntityDamageEvent.DamageModifier.BASE) * 0.2 * (double)(damager.getEffect(18).getAmplifier() + 1))), EntityDamageEvent.DamageModifier.WEAKNESS);
        }
    }

    @Nonnull
    public Entity getDamager() {
        return this.damager;
    }

    public float getKnockBack() {
        return this.knockBack;
    }

    public void setKnockBack(float knockBack) {
        this.knockBack = knockBack;
    }

    @Nullable
    @Since(value="1.6.0.0-PN")
    public Enchantment[] getWeaponEnchantments() {
        if (this.enchantments == null) {
            return null;
        }
        return this.enchantments.length > 0 ? (Enchantment[])this.enchantments.clone() : Enchantment.EMPTY_ARRAY;
    }
}

