/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.entity;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.entity.EntityEvent;

public class EntityExplosionPrimeEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private double force;
    private boolean blockBreaking;
    private double fireChance;

    public static HandlerList getHandlers() {
        return handlers;
    }

    public EntityExplosionPrimeEvent(Entity entity, double force) {
        this.entity = entity;
        this.force = force;
        this.blockBreaking = true;
    }

    public double getForce() {
        return this.force;
    }

    public void setForce(double force) {
        this.force = force;
    }

    public boolean isBlockBreaking() {
        return this.blockBreaking;
    }

    public void setBlockBreaking(boolean blockBreaking) {
        this.blockBreaking = blockBreaking;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isIncendiary() {
        return this.fireChance > 0.0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setIncendiary(boolean incendiary) {
        if (!incendiary) {
            this.fireChance = 0.0;
        } else if (this.fireChance <= 0.0) {
            this.fireChance = 0.3333333333333333;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public double getFireChance() {
        return this.fireChance;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setFireChance(double fireChance) {
        this.fireChance = fireChance;
    }
}

