/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.inventory;

import cn.nukkit.Player;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.Event;
import cn.nukkit.event.HandlerList;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.transaction.CraftingTransaction;
import cn.nukkit.item.Item;

public class CraftItemEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private Item[] input = Item.EMPTY_ARRAY;
    private final Recipe recipe;
    private final Player player;
    private CraftingTransaction transaction;

    public static HandlerList getHandlers() {
        return handlers;
    }

    public CraftItemEvent(CraftingTransaction transaction) {
        this.transaction = transaction;
        this.player = transaction.getSource();
        this.input = transaction.getInputList().toArray(Item.EMPTY_ARRAY);
        this.recipe = transaction.getTransactionRecipe();
    }

    public CraftItemEvent(Player player, Item[] input, Recipe recipe) {
        this.player = player;
        this.input = input;
        this.recipe = recipe;
    }

    public CraftingTransaction getTransaction() {
        return this.transaction;
    }

    public Item[] getInput() {
        return this.input;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public Player getPlayer() {
        return this.player;
    }
}

