/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemPotion;
import cn.nukkit.potion.Potion;
import cn.nukkit.utils.ServerException;
import javax.annotation.Nullable;

public class ItemArrow
extends Item {
    private static final String GENERIC_NAME = "Arrow";

    public ItemArrow() {
        this((Integer)0, 1);
    }

    public ItemArrow(Integer meta) {
        this(meta, 1);
    }

    public ItemArrow(Integer meta, int count) {
        super(262, meta, count, GENERIC_NAME);
        this.updateName();
    }

    @Override
    public void setDamage(Integer meta) {
        super.setDamage(meta);
        this.updateName();
    }

    private void updateName() {
        int type = this.getDamage();
        if (type <= 0) {
            this.name = GENERIC_NAME;
            return;
        }
        int potionId = type - 1;
        switch (potionId) {
            case 0: {
                this.name = "Arrow of Splashing";
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.name = "Tipped Arrow";
                return;
            }
        }
        this.name = ItemPotion.buildName(potionId, GENERIC_NAME, false);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public Potion getTippedArrowPotion() {
        int damage = this.getDamage();
        if (damage > 0) {
            try {
                return Potion.getPotion(damage - 1);
            }
            catch (ServerException ignored) {
                return null;
            }
        }
        return null;
    }
}

