/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.item.ItemPotion;
import cn.nukkit.item.ProjectileItem;
import cn.nukkit.nbt.tag.CompoundTag;

public class ItemPotionSplash
extends ProjectileItem {
    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public ItemPotionSplash() {
        this((Integer)0, 1);
    }

    public ItemPotionSplash(Integer meta) {
        this(meta, 1);
    }

    public ItemPotionSplash(Integer meta, int count) {
        super(438, meta, count, "Splash Potion");
        this.updateName();
    }

    @Override
    public void setDamage(Integer meta) {
        super.setDamage(meta);
        this.updateName();
    }

    private void updateName() {
        int potionId = this.getDamage();
        this.name = potionId == 0 ? "Splash Water Bottle" : ItemPotion.buildName(potionId, "Splash Potion", true);
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public String getProjectileEntityType() {
        return "ThrownPotion";
    }

    @Override
    public float getThrowForce() {
        return 0.5f;
    }

    @Override
    protected void correctNBT(CompoundTag nbt) {
        nbt.putInt("PotionId", this.meta);
    }
}

