/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.CreatureSpawnEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.Random;
import javax.annotation.Nullable;

public class ItemSpawnEgg
extends Item {
    public ItemSpawnEgg() {
        this((Integer)0, 1);
    }

    public ItemSpawnEgg(Integer meta) {
        this(meta, 1);
    }

    public ItemSpawnEgg(Integer meta, int count) {
        this(383, meta, count, "Spawn Egg");
        this.updateName();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected ItemSpawnEgg(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    @Override
    public void setDamage(Integer meta) {
        super.setDamage(meta);
        this.updateName();
    }

    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    protected void updateName() {
        String entityName = this.getEntityName();
        this.name = entityName == null ? "Spawn Egg" : entityName + " Spawn Egg";
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (player.isAdventure()) {
            return false;
        }
        BaseFullChunk chunk = level.getChunk((int)block.getX() >> 4, (int)block.getZ() >> 4);
        if (chunk == null) {
            return false;
        }
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", block.getX() + 0.5)).add(new DoubleTag("", target.getBoundingBox() == null ? block.getY() : target.getBoundingBox().getMaxY() + (double)1.0E-4f)).add(new DoubleTag("", block.getZ() + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", new Random().nextFloat() * 360.0f)).add(new FloatTag("", 0.0f)));
        if (this.hasCustomName()) {
            nbt.putString("CustomName", this.getCustomName());
        }
        int networkId = this.getEntityNetworkId();
        CreatureSpawnEvent ev = new CreatureSpawnEvent(networkId, block, nbt, CreatureSpawnEvent.SpawnReason.SPAWN_EGG);
        level.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        Entity entity = Entity.createEntity(networkId, (FullChunk)chunk, nbt, new Object[0]);
        if (entity != null) {
            if (player.isSurvival()) {
                player.getInventory().decreaseCount(player.getInventory().getHeldItemIndex());
            }
            entity.spawnToAll();
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getEntityNetworkId() {
        return this.meta;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public String getEntityName() {
        String saveId = Entity.getSaveId(this.getEntityNetworkId());
        if (saveId == null) {
            return null;
        }
        switch (saveId) {
            case "VillagerV1": {
                return "Villager";
            }
            case "ZombieVillagerV1": {
                return "Zombie Villager";
            }
            case "NPC": {
                return "NPC";
            }
        }
        return String.join((CharSequence)" ", saveId.split("(?=\\p{Lu})"));
    }
}

