/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemDurable;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.Utils;
import java.util.Random;
import javax.annotation.Nonnull;

public abstract class ItemTool
extends Item
implements ItemDurable {
    public static final int TIER_WOODEN = 1;
    public static final int TIER_GOLD = 2;
    public static final int TIER_STONE = 3;
    public static final int TIER_IRON = 4;
    public static final int TIER_DIAMOND = 5;
    @Since(value="1.4.0.0-PN")
    public static final int TIER_NETHERITE = 6;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_SWORD = 1;
    public static final int TYPE_SHOVEL = 2;
    public static final int TYPE_PICKAXE = 3;
    public static final int TYPE_AXE = 4;
    public static final int TYPE_SHEARS = 5;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_HOE = 6;
    @PowerNukkitOnly
    public static final int TYPE_HANDS_ONLY = Utils.dynamic(Integer.MAX_VALUE);
    public static final int DURABILITY_WOODEN = Utils.dynamic(60);
    public static final int DURABILITY_GOLD = Utils.dynamic(33);
    public static final int DURABILITY_STONE = Utils.dynamic(132);
    public static final int DURABILITY_IRON = Utils.dynamic(251);
    public static final int DURABILITY_DIAMOND = Utils.dynamic(1562);
    @Since(value="1.4.0.0-PN")
    public static final int DURABILITY_NETHERITE = Utils.dynamic(2032);
    public static final int DURABILITY_FLINT_STEEL = Utils.dynamic(65);
    public static final int DURABILITY_SHEARS = Utils.dynamic(239);
    public static final int DURABILITY_BOW = Utils.dynamic(385);
    public static final int DURABILITY_TRIDENT = Utils.dynamic(251);
    public static final int DURABILITY_FISHING_ROD = Utils.dynamic(384);
    @Since(value="1.4.0.0-PN")
    public static final int DURABILITY_CROSSBOW = Utils.dynamic(464);
    @Since(value="1.6.0.0-PN")
    public static final int DURABILITY_CARROT_ON_A_STICK = Utils.dynamic(26);
    @Since(value="1.6.0.0-PN")
    public static final int DURABILITY_WARPED_FUNGUS_ON_A_STICK = Utils.dynamic(101);
    @Since(value="1.6.0.0-PN")
    @PowerNukkitOnly
    public static final int DURABILITY_SHIELD = Utils.dynamic(337);

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static Item getBestTool(int toolType) {
        switch (toolType) {
            case 0: 
            case 3: {
                return Item.get(745);
            }
            case 4: {
                return Item.get(746);
            }
            case 2: {
                return Item.get(744);
            }
            case 5: {
                return Item.get(359);
            }
            case 1: {
                return Item.get(743);
            }
        }
        if (toolType == 6) {
            return Item.get(747);
        }
        if (toolType == TYPE_HANDS_ONLY) {
            return Item.getBlock(0);
        }
        return Item.get(745);
    }

    public ItemTool(int id) {
        this(id, 0, 1, UNKNOWN_STR);
    }

    public ItemTool(int id, Integer meta) {
        this(id, meta, 1, UNKNOWN_STR);
    }

    public ItemTool(int id, Integer meta, int count) {
        this(id, meta, count, UNKNOWN_STR);
    }

    public ItemTool(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean useOn(Block block) {
        if (this.isUnbreakable() || this.isDurable() || this.noDamageOnBreak()) {
            return true;
        }
        if (block.getToolType() == 3 && this.isPickaxe() || block.getToolType() == 2 && this.isShovel() || block.getToolType() == 4 && this.isAxe() || block.getToolType() == 6 && this.isHoe() || block.getToolType() == 1 && this.isSword() || block.getToolType() == 5 && this.isShears() || block.getToolType() == 6 && this.isHoe()) {
            ++this.meta;
        } else if (!this.isShears() && block.calculateBreakTime(this) > 0.0) {
            this.meta += 2;
        } else if (this.isHoe()) {
            if (block.getId() == 2 || block.getId() == 3) {
                ++this.meta;
            }
        } else {
            ++this.meta;
        }
        return true;
    }

    @Override
    public boolean useOn(Entity entity) {
        if (this.isUnbreakable() || this.isDurable() || this.noDamageOnAttack()) {
            return true;
        }
        this.meta = entity != null && !this.isSword() ? (this.meta += 2) : ++this.meta;
        return true;
    }

    private boolean isDurable() {
        if (!this.hasEnchantments()) {
            return false;
        }
        Enchantment durability = this.getEnchantment(17);
        return durability != null && durability.getLevel() > 0 && 100 / (durability.getLevel() + 1) <= new Random().nextInt(100);
    }

    @Override
    public boolean isUnbreakable() {
        Tag tag = this.getNamedTagEntry("Unbreakable");
        return tag instanceof ByteTag && ((ByteTag)tag).data > 0;
    }

    @Override
    public boolean isPickaxe() {
        return false;
    }

    @Override
    public boolean isAxe() {
        return false;
    }

    @Override
    public boolean isSword() {
        return false;
    }

    @Override
    public boolean isShovel() {
        return false;
    }

    @Override
    public boolean isHoe() {
        return false;
    }

    @Override
    public boolean isShears() {
        return this.id == 359;
    }

    @Override
    public boolean isTool() {
        return true;
    }

    @Override
    public int getEnchantAbility() {
        int tier = this.getTier();
        switch (tier) {
            case 3: {
                return 5;
            }
            case 1: 
            case 5: {
                return 10;
            }
            case 2: {
                return 22;
            }
            case 4: {
                return 14;
            }
        }
        if (tier == 6) {
            return 15;
        }
        return 0;
    }

    @Since(value="1.6.0.0-PN")
    public boolean noDamageOnAttack() {
        return false;
    }

    @Since(value="1.6.0.0-PN")
    public boolean noDamageOnBreak() {
        return false;
    }
}

