/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.item.Item;
import cn.nukkit.item.RuntimeItems;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@Since(value="1.4.0.0-PN")
public class RuntimeItemMapping {
    private final Int2IntMap legacyNetworkMap;
    private final Int2IntMap networkLegacyMap;
    private final byte[] itemDataPalette;
    private final Map<String, OptionalInt> namespaceNetworkMap;
    private final Int2ObjectMap<String> networkNamespaceMap;

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public RuntimeItemMapping(byte[] itemDataPalette, Int2IntMap legacyNetworkMap, Int2IntMap networkLegacyMap) {
        this.itemDataPalette = itemDataPalette;
        this.legacyNetworkMap = legacyNetworkMap;
        this.networkLegacyMap = networkLegacyMap;
        this.legacyNetworkMap.defaultReturnValue(-1);
        this.networkLegacyMap.defaultReturnValue(-1);
        this.namespaceNetworkMap = new LinkedHashMap<String, OptionalInt>();
        this.networkNamespaceMap = new Int2ObjectOpenHashMap();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public RuntimeItemMapping(byte[] itemDataPalette, Int2IntMap legacyNetworkMap, Int2IntMap networkLegacyMap, Map<String, Integer> namespaceNetworkMap, Int2ObjectMap<String> networkNamespaceMap) {
        this.itemDataPalette = itemDataPalette;
        this.legacyNetworkMap = legacyNetworkMap;
        this.networkLegacyMap = networkLegacyMap;
        this.legacyNetworkMap.defaultReturnValue(-1);
        this.networkLegacyMap.defaultReturnValue(-1);
        this.networkNamespaceMap = networkNamespaceMap;
        this.namespaceNetworkMap = namespaceNetworkMap.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), OptionalInt.of((Integer)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getNetworkFullId(Item item) {
        int fullId = RuntimeItems.getFullId(item.getId(), item.hasMeta() ? item.getDamage() : -1);
        int networkId = this.legacyNetworkMap.get(fullId);
        if (networkId == -1 && !item.hasMeta() && item.getDamage() != 0) {
            networkId = this.legacyNetworkMap.get(RuntimeItems.getFullId(item.getId(), item.getDamage()));
        }
        if (networkId == -1) {
            networkId = this.legacyNetworkMap.get(RuntimeItems.getFullId(item.getId(), 0));
        }
        if (networkId == -1) {
            throw new IllegalArgumentException("Unknown item mapping " + item);
        }
        return networkId;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getLegacyFullId(int networkId) {
        int fullId = this.networkLegacyMap.get(networkId);
        if (fullId == -1) {
            throw new IllegalArgumentException("Unknown network mapping: " + networkId);
        }
        return fullId;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public byte[] getItemDataPalette() {
        return this.itemDataPalette;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getNamespacedIdByNetworkId(int networkId) {
        return (String)this.networkNamespaceMap.get(networkId);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public OptionalInt getNetworkIdByNamespaceId(@Nonnull String namespaceId) {
        return this.namespaceNetworkMap.getOrDefault(namespaceId, OptionalInt.empty());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getItemByNamespaceId(@Nonnull String namespaceId, int amount) {
        int legacyFullId = this.getLegacyFullId(this.getNetworkIdByNamespaceId(namespaceId).orElseThrow(() -> new IllegalArgumentException("The network id of \"" + namespaceId + "\" is unknown")));
        if (RuntimeItems.hasData(legacyFullId)) {
            return Item.get(RuntimeItems.getId(legacyFullId), RuntimeItems.getData(legacyFullId), amount);
        }
        Item item = Item.get(RuntimeItems.getId(legacyFullId));
        item.setCount(amount);
        return item;
    }

    @Since(value="1.6.0.0-PN")
    public static class RuntimeEntry {
        private final String identifier;
        private final int runtimeId;
        private final boolean hasDamage;

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RuntimeEntry)) {
                return false;
            }
            RuntimeEntry other = (RuntimeEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            if (this.getRuntimeId() != other.getRuntimeId()) {
                return false;
            }
            return this.isHasDamage() == other.isHasDamage();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RuntimeEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            result = result * 59 + this.getRuntimeId();
            result = result * 59 + (this.isHasDamage() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "RuntimeItemMapping.RuntimeEntry(identifier=" + this.getIdentifier() + ", runtimeId=" + this.getRuntimeId() + ", hasDamage=" + this.isHasDamage() + ")";
        }

        @Since(value="1.6.0.0-PN")
        @Generated
        public String getIdentifier() {
            return this.identifier;
        }

        @Since(value="1.6.0.0-PN")
        @Generated
        public int getRuntimeId() {
            return this.runtimeId;
        }

        @Since(value="1.6.0.0-PN")
        @Generated
        public boolean isHasDamage() {
            return this.hasDamage;
        }

        @Since(value="1.6.0.0-PN")
        @Generated
        public RuntimeEntry(String identifier, int runtimeId, boolean hasDamage) {
            this.identifier = identifier;
            this.runtimeId = runtimeId;
            this.hasDamage = hasDamage;
        }
    }

    @Since(value="1.6.0.0-PN")
    public static class LegacyEntry {
        private final int legacyId;
        private final boolean hasDamage;
        private final int damage;

        public int getDamage() {
            return this.hasDamage ? this.damage : 0;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LegacyEntry)) {
                return false;
            }
            LegacyEntry other = (LegacyEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLegacyId() != other.getLegacyId()) {
                return false;
            }
            if (this.isHasDamage() != other.isHasDamage()) {
                return false;
            }
            return this.getDamage() == other.getDamage();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LegacyEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLegacyId();
            result = result * 59 + (this.isHasDamage() ? 79 : 97);
            result = result * 59 + this.getDamage();
            return result;
        }

        @Generated
        public String toString() {
            return "RuntimeItemMapping.LegacyEntry(legacyId=" + this.getLegacyId() + ", hasDamage=" + this.isHasDamage() + ", damage=" + this.getDamage() + ")";
        }

        @Since(value="1.6.0.0-PN")
        @Generated
        public int getLegacyId() {
            return this.legacyId;
        }

        @Since(value="1.6.0.0-PN")
        @Generated
        public boolean isHasDamage() {
            return this.hasDamage;
        }

        @Since(value="1.6.0.0-PN")
        @Generated
        public LegacyEntry(int legacyId, boolean hasDamage, int damage) {
            this.legacyId = legacyId;
            this.hasDamage = hasDamage;
            this.damage = damage;
        }
    }
}

