/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.enchantment;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.EnchantmentBindingCurse;
import cn.nukkit.item.enchantment.EnchantmentDurability;
import cn.nukkit.item.enchantment.EnchantmentEfficiency;
import cn.nukkit.item.enchantment.EnchantmentFireAspect;
import cn.nukkit.item.enchantment.EnchantmentFrostWalker;
import cn.nukkit.item.enchantment.EnchantmentKnockback;
import cn.nukkit.item.enchantment.EnchantmentLure;
import cn.nukkit.item.enchantment.EnchantmentMending;
import cn.nukkit.item.enchantment.EnchantmentSilkTouch;
import cn.nukkit.item.enchantment.EnchantmentSoulSpeed;
import cn.nukkit.item.enchantment.EnchantmentThorns;
import cn.nukkit.item.enchantment.EnchantmentType;
import cn.nukkit.item.enchantment.EnchantmentVanishingCurse;
import cn.nukkit.item.enchantment.EnchantmentWaterBreath;
import cn.nukkit.item.enchantment.EnchantmentWaterWalker;
import cn.nukkit.item.enchantment.EnchantmentWaterWorker;
import cn.nukkit.item.enchantment.bow.EnchantmentBowFlame;
import cn.nukkit.item.enchantment.bow.EnchantmentBowInfinity;
import cn.nukkit.item.enchantment.bow.EnchantmentBowKnockback;
import cn.nukkit.item.enchantment.bow.EnchantmentBowPower;
import cn.nukkit.item.enchantment.crossbow.EnchantmentCrossbowMultishot;
import cn.nukkit.item.enchantment.crossbow.EnchantmentCrossbowPiercing;
import cn.nukkit.item.enchantment.crossbow.EnchantmentCrossbowQuickCharge;
import cn.nukkit.item.enchantment.damage.EnchantmentDamageAll;
import cn.nukkit.item.enchantment.damage.EnchantmentDamageArthropods;
import cn.nukkit.item.enchantment.damage.EnchantmentDamageSmite;
import cn.nukkit.item.enchantment.loot.EnchantmentLootDigging;
import cn.nukkit.item.enchantment.loot.EnchantmentLootFishing;
import cn.nukkit.item.enchantment.loot.EnchantmentLootWeapon;
import cn.nukkit.item.enchantment.protection.EnchantmentProtectionAll;
import cn.nukkit.item.enchantment.protection.EnchantmentProtectionExplosion;
import cn.nukkit.item.enchantment.protection.EnchantmentProtectionFall;
import cn.nukkit.item.enchantment.protection.EnchantmentProtectionFire;
import cn.nukkit.item.enchantment.protection.EnchantmentProtectionProjectile;
import cn.nukkit.item.enchantment.sideeffect.SideEffect;
import cn.nukkit.item.enchantment.trident.EnchantmentTridentChanneling;
import cn.nukkit.item.enchantment.trident.EnchantmentTridentImpaling;
import cn.nukkit.item.enchantment.trident.EnchantmentTridentLoyalty;
import cn.nukkit.item.enchantment.trident.EnchantmentTridentRiptide;
import cn.nukkit.math.NukkitMath;
import io.netty.util.internal.EmptyArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class Enchantment
implements Cloneable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final Enchantment[] EMPTY_ARRAY = new Enchantment[0];
    protected static Enchantment[] enchantments;
    public static final int ID_PROTECTION_ALL = 0;
    public static final int ID_PROTECTION_FIRE = 1;
    public static final int ID_PROTECTION_FALL = 2;
    public static final int ID_PROTECTION_EXPLOSION = 3;
    public static final int ID_PROTECTION_PROJECTILE = 4;
    public static final int ID_THORNS = 5;
    public static final int ID_WATER_BREATHING = 6;
    public static final int ID_WATER_WALKER = 7;
    public static final int ID_WATER_WORKER = 8;
    public static final int ID_DAMAGE_ALL = 9;
    public static final int ID_DAMAGE_SMITE = 10;
    public static final int ID_DAMAGE_ARTHROPODS = 11;
    public static final int ID_KNOCKBACK = 12;
    public static final int ID_FIRE_ASPECT = 13;
    public static final int ID_LOOTING = 14;
    public static final int ID_EFFICIENCY = 15;
    public static final int ID_SILK_TOUCH = 16;
    public static final int ID_DURABILITY = 17;
    public static final int ID_FORTUNE_DIGGING = 18;
    public static final int ID_BOW_POWER = 19;
    public static final int ID_BOW_KNOCKBACK = 20;
    public static final int ID_BOW_FLAME = 21;
    public static final int ID_BOW_INFINITY = 22;
    public static final int ID_FORTUNE_FISHING = 23;
    public static final int ID_LURE = 24;
    public static final int ID_FROST_WALKER = 25;
    public static final int ID_MENDING = 26;
    public static final int ID_BINDING_CURSE = 27;
    public static final int ID_VANISHING_CURSE = 28;
    public static final int ID_TRIDENT_IMPALING = 29;
    public static final int ID_TRIDENT_RIPTIDE = 30;
    public static final int ID_TRIDENT_LOYALTY = 31;
    public static final int ID_TRIDENT_CHANNELING = 32;
    @Since(value="1.4.0.0-PN")
    public static final int ID_CROSSBOW_MULTISHOT = 33;
    @Since(value="1.4.0.0-PN")
    public static final int ID_CROSSBOW_PIERCING = 34;
    @Since(value="1.4.0.0-PN")
    public static final int ID_CROSSBOW_QUICK_CHARGE = 35;
    @Since(value="1.4.0.0-PN")
    public static final int ID_SOUL_SPEED = 36;
    public final int id;
    private final Rarity rarity;
    @Nonnull
    public EnchantmentType type;
    protected int level = 1;
    protected final String name;
    public static final String[] words;

    public static void init() {
        enchantments = new Enchantment[256];
        Enchantment.enchantments[0] = new EnchantmentProtectionAll();
        Enchantment.enchantments[1] = new EnchantmentProtectionFire();
        Enchantment.enchantments[2] = new EnchantmentProtectionFall();
        Enchantment.enchantments[3] = new EnchantmentProtectionExplosion();
        Enchantment.enchantments[4] = new EnchantmentProtectionProjectile();
        Enchantment.enchantments[5] = new EnchantmentThorns();
        Enchantment.enchantments[6] = new EnchantmentWaterBreath();
        Enchantment.enchantments[8] = new EnchantmentWaterWorker();
        Enchantment.enchantments[7] = new EnchantmentWaterWalker();
        Enchantment.enchantments[9] = new EnchantmentDamageAll();
        Enchantment.enchantments[10] = new EnchantmentDamageSmite();
        Enchantment.enchantments[11] = new EnchantmentDamageArthropods();
        Enchantment.enchantments[12] = new EnchantmentKnockback();
        Enchantment.enchantments[13] = new EnchantmentFireAspect();
        Enchantment.enchantments[14] = new EnchantmentLootWeapon();
        Enchantment.enchantments[15] = new EnchantmentEfficiency();
        Enchantment.enchantments[16] = new EnchantmentSilkTouch();
        Enchantment.enchantments[17] = new EnchantmentDurability();
        Enchantment.enchantments[18] = new EnchantmentLootDigging();
        Enchantment.enchantments[19] = new EnchantmentBowPower();
        Enchantment.enchantments[20] = new EnchantmentBowKnockback();
        Enchantment.enchantments[21] = new EnchantmentBowFlame();
        Enchantment.enchantments[22] = new EnchantmentBowInfinity();
        Enchantment.enchantments[23] = new EnchantmentLootFishing();
        Enchantment.enchantments[24] = new EnchantmentLure();
        Enchantment.enchantments[25] = new EnchantmentFrostWalker();
        Enchantment.enchantments[26] = new EnchantmentMending();
        Enchantment.enchantments[27] = new EnchantmentBindingCurse();
        Enchantment.enchantments[28] = new EnchantmentVanishingCurse();
        Enchantment.enchantments[29] = new EnchantmentTridentImpaling();
        Enchantment.enchantments[30] = new EnchantmentTridentRiptide();
        Enchantment.enchantments[31] = new EnchantmentTridentLoyalty();
        Enchantment.enchantments[32] = new EnchantmentTridentChanneling();
        Enchantment.enchantments[33] = new EnchantmentCrossbowMultishot();
        Enchantment.enchantments[34] = new EnchantmentCrossbowPiercing();
        Enchantment.enchantments[35] = new EnchantmentCrossbowQuickCharge();
        Enchantment.enchantments[36] = new EnchantmentSoulSpeed();
    }

    @Deprecated
    @DeprecationDetails(by="PowerNukkit", reason="This is very insecure and can break the environment", since="1.4.0.0-PN", replaceWith="getEnchantment(int)")
    public static Enchantment get(int id) {
        Enchantment enchantment = null;
        if (id >= 0 && id < enchantments.length) {
            enchantment = enchantments[id];
        }
        if (enchantment == null) {
            return new UnknownEnchantment(id);
        }
        return enchantment;
    }

    public static Enchantment getEnchantment(int id) {
        return Enchantment.get(id).clone();
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="The objects returned by this method are not safe to use and the implementation may skip some enchantments", replaceWith="getRegisteredEnchantments()")
    public static Enchantment[] getEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        for (Enchantment enchantment : enchantments) {
            if (enchantment == null) break;
            list.add(enchantment);
        }
        return list.toArray(EMPTY_ARRAY);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static Collection<Enchantment> getRegisteredEnchantments() {
        return Arrays.stream(enchantments).filter(Objects::nonNull).map(Enchantment::clone).collect(Collectors.toList());
    }

    @Deprecated
    @PowerNukkitOnly(value="Was removed from Nukkit in 1.4.0.0-PN, keeping it in PowerNukkit for backward compatibility")
    @DeprecationDetails(by="Cloudburst Nukkit", since="1.4.0.0-PN", reason="Changed the signature without backward compatibility", replaceWith="Enchantment(int, String, Rarity, EnchantmentType)")
    protected Enchantment(int id, String name, int weight, EnchantmentType type) {
        this(id, name, Rarity.fromWeight(weight), type);
    }

    @Since(value="1.4.0.0-PN")
    protected Enchantment(int id, String name, Rarity rarity, EnchantmentType type) {
        this.id = id;
        this.rarity = rarity;
        this.type = type;
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    @Nonnull
    public Enchantment setLevel(int level) {
        return this.setLevel(level, true);
    }

    @Nonnull
    public Enchantment setLevel(int level, boolean safe) {
        if (!safe) {
            this.level = level;
            return this;
        }
        this.level = NukkitMath.clamp(level, this.getMinLevel(), this.getMaxLevel());
        return this;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    @Since(value="1.4.0.0-PN")
    public Rarity getRarity() {
        return this.rarity;
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="Cloudburst Nukkit", reason="Refactored enchantments and now uses a Rarity enum", replaceWith="getRarity().getWeight()")
    public int getWeight() {
        return this.rarity.getWeight();
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return 1;
    }

    public int getMaxEnchantableLevel() {
        return this.getMaxLevel();
    }

    public int getMinEnchantAbility(int level) {
        return 1 + level * 10;
    }

    public int getMaxEnchantAbility(int level) {
        return this.getMinEnchantAbility(level) + 5;
    }

    public float getProtectionFactor(EntityDamageEvent event) {
        return 0.0f;
    }

    public double getDamageBonus(Entity entity) {
        return 0.0;
    }

    public void doPostAttack(Entity attacker, Entity entity) {
    }

    @Since(value="1.6.0.0-PN")
    public void doAttack(Entity attacker, Entity entity) {
    }

    public void doPostHurt(Entity attacker, Entity entity) {
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Cloudburst Nukkit added the final modifier, we removed it to maintain backward compatibility. The right way to implement compatibility now is to override checkCompatibility(Enchantment enchantment) and also make sure to keep it protected! Some overrides was incorrectly made public, let's avoid this mistake.")
    public boolean isCompatibleWith(@Nonnull Enchantment enchantment) {
        return this.checkCompatibility(enchantment) && enchantment.checkCompatibility(this);
    }

    @Since(value="1.4.0.0-PN")
    protected boolean checkCompatibility(Enchantment enchantment) {
        return this != enchantment;
    }

    public String getName() {
        return "%enchantment." + this.name;
    }

    public boolean canEnchant(@Nonnull Item item) {
        return this.type.canEnchantItem(item);
    }

    public boolean isMajor() {
        return false;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public SideEffect[] getAttackSideEffects(@Nonnull Entity attacker, @Nonnull Entity entity) {
        return SideEffect.EMPTY_ARRAY;
    }

    protected Enchantment clone() {
        try {
            return (Enchantment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Deprecated
    @PowerNukkitOnly
    @Since(value="1.2.1.0-PN")
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Does the same as canEnchant(item)", replaceWith="canEnchant(item)")
    public boolean isItemAcceptable(Item item) {
        return this.canEnchant(item);
    }

    public static String getRandomName() {
        int count = ThreadLocalRandom.current().nextInt(3, 6);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        while (set.size() < count) {
            set.add(words[ThreadLocalRandom.current().nextInt(0, words.length)]);
        }
        CharSequence[] words = set.toArray(EmptyArrays.EMPTY_STRINGS);
        return String.join((CharSequence)" ", words);
    }

    static {
        words = new String[]{"the", "elder", "scrolls", "klaatu", "berata", "niktu", "xyzzy", "bless", "curse", "light", "darkness", "fire", "air", "earth", "water", "hot", "dry", "cold", "wet", "ignite", "snuff", "embiggen", "twist", "shorten", "stretch", "fiddle", "destroy", "imbue", "galvanize", "enchant", "free", "limited", "range", "of", "towards", "inside", "sphere", "cube", "self", "other", "ball", "mental", "physical", "grow", "shrink", "demon", "elemental", "spirit", "animal", "creature", "beast", "humanoid", "undead", "fresh", "stale"};
    }

    @Since(value="1.4.0.0-PN")
    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int weight;

        private Rarity(int weight) {
            this.weight = weight;
        }

        @Since(value="1.4.0.0-PN")
        public int getWeight() {
            return this.weight;
        }

        @Since(value="1.4.0.0-PN")
        public static Rarity fromWeight(int weight) {
            if (weight < 2) {
                return VERY_RARE;
            }
            if (weight < 5) {
                return RARE;
            }
            if (weight < 10) {
                return UNCOMMON;
            }
            return COMMON;
        }
    }

    private static class UnknownEnchantment
    extends Enchantment {
        protected UnknownEnchantment(int id) {
            super(id, "unknown", Rarity.VERY_RARE, EnchantmentType.ALL);
        }
    }
}

