/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.enchantment.sideeffect;

import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityCombustByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.enchantment.sideeffect.SideEffect;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.5.1.0-PN")
public class SideEffectCombust
implements SideEffect {
    private int duration;

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public SideEffectCombust(int duration) {
        this.duration = duration;
    }

    @Override
    @Since(value="1.5.1.0-PN")
    @PowerNukkitOnly
    public void doPreHealthChange(@Nonnull Entity entity, @Nonnull EntityDamageEvent event, @Nullable Entity attacker) {
        EntityCombustByEntityEvent ev = new EntityCombustByEntityEvent(attacker, entity, this.duration);
        Server.getInstance().getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            entity.setOnFire(ev.getDuration());
        }
    }

    @Since(value="1.5.1.0-PN")
    @PowerNukkitOnly
    public int getDuration() {
        return this.duration;
    }

    @Since(value="1.5.1.0-PN")
    @PowerNukkitOnly
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Deprecated
    @Nonnull
    @DeprecationDetails(since="1.6.0.0-PN", reason="clone have problems when defined in an interface", by="PowerNukkit", replaceWith="cloneSideEffect")
    @Since(value="1.5.1.0-PN")
    public SideEffect clone() {
        return (SideEffect)super.clone();
    }

    @Override
    @Nonnull
    @Since(value="1.6.0.0-PN")
    @PowerNukkitOnly
    public SideEffect cloneSideEffect() {
        return (SideEffect)super.clone();
    }
}

