/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.ChunkVector2;
import javax.annotation.Nonnull;

public interface ChunkManager {
    @PowerNukkitOnly
    public int getBlockIdAt(int var1, int var2, int var3, int var4);

    public int getBlockIdAt(int var1, int var2, int var3);

    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public void setBlockFullIdAt(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public void setBlockFullIdAt(int var1, int var2, int var3, int var4);

    @PowerNukkitOnly
    public void setBlockIdAt(int var1, int var2, int var3, int var4, int var5);

    public void setBlockIdAt(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean setBlockAtLayer(int var1, int var2, int var3, int var4, int var5, int var6);

    @PowerNukkitOnly
    default public boolean setBlockAtLayer(int x, int y, int z, int layer, int id) {
        return this.setBlockAtLayer(x, y, z, layer, id, 0);
    }

    default public void setBlockAt(int x, int y, int z, int id) {
        this.setBlockStateAt(x, y, z, BlockState.of(id));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setBlockStateAt(int var1, int var2, int var3, int var4, BlockState var5);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean setBlockStateAt(int x, int y, int z, BlockState state) {
        return this.setBlockStateAt(x, y, z, 0, state);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getBlockStateAt(int var1, int var2, int var3, int var4);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BlockState getBlockStateAt(int x, int y, int z) {
        return this.getBlockStateAt(x, y, z, 0);
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public void setBlockAt(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getBlockDataAt(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public int getBlockDataAt(int var1, int var2, int var3);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockDataAt(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public void setBlockDataAt(int var1, int var2, int var3, int var4);

    public BaseFullChunk getChunk(int var1, int var2);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BaseFullChunk getChunk(@Nonnull ChunkVector2 pos) {
        return this.getChunk(pos.getX(), pos.getZ());
    }

    public void setChunk(int var1, int var2);

    public void setChunk(int var1, int var2, BaseFullChunk var3);

    public long getSeed();
}

