/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockID;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public abstract class Biome
implements BlockID {
    public static final int MAX_BIOMES = 256;
    public static final Biome[] biomes = new Biome[256];
    public static final List<Biome> unorderedBiomes = new ObjectArrayList();
    private static final Int2ObjectMap<String> runtimeId2Identifier = new Int2ObjectOpenHashMap();
    private final ArrayList<Populator> populators = new ArrayList();
    private int id;
    private float baseHeight = 0.1f;
    private float heightVariation = 0.3f;

    public static String getBiomeNameFromId(int biomeId) {
        return (String)runtimeId2Identifier.get(biomeId);
    }

    public static int getBiomeIdOrCorrect(int biomeId) {
        if (runtimeId2Identifier.get(biomeId) == null) {
            return EnumBiome.OCEAN.id;
        }
        return biomeId;
    }

    protected static void register(int id, Biome biome) {
        biome.setId(id);
        Biome.biomes[id] = biome;
        unorderedBiomes.add(biome);
    }

    public static Biome getBiome(int id) {
        Biome biome = biomes[id];
        return biome != null ? biome : EnumBiome.OCEAN.biome;
    }

    public static Biome getBiome(String name) {
        for (Biome biome : biomes) {
            if (biome == null || !biome.getName().equalsIgnoreCase(name.replace("_", " "))) continue;
            return biome;
        }
        return null;
    }

    public void clearPopulators() {
        this.populators.clear();
    }

    public void addPopulator(Populator populator) {
        this.populators.add(populator);
    }

    public void populateChunk(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random) {
        BaseFullChunk chunk = level.getChunk(chunkX, chunkZ);
        for (Populator populator : this.populators) {
            populator.populate(level, chunkX, chunkZ, random, chunk);
        }
    }

    public ArrayList<Populator> getPopulators() {
        return this.populators;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public abstract String getName();

    public void setBaseHeight(float baseHeight) {
        this.baseHeight = baseHeight;
    }

    public void setHeightVariation(float heightVariation) {
        this.heightVariation = heightVariation;
    }

    public float getBaseHeight() {
        return this.baseHeight;
    }

    public float getHeightVariation() {
        return this.heightVariation;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public boolean isFreezing() {
        return false;
    }

    public boolean doesOverhang() {
        return false;
    }

    public int getHeightOffset(int x, int z) {
        return 0;
    }

    public boolean canRain() {
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isDry() {
        return false;
    }

    static {
        try (InputStream stream = Biome.class.getClassLoader().getResourceAsStream("biome_id_map.json");){
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
            for (String identifier : json.keySet()) {
                int biomeId = json.get(identifier).getAsInt();
                runtimeId2Identifier.put(biomeId, (Object)identifier);
            }
        }
        catch (IOException | NullPointerException e) {
            throw new AssertionError("Unable to load biome mapping from biome_id_map.json", e);
        }
    }
}

