/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.format.anvil.LayerStorage;
import cn.nukkit.level.format.anvil.MultiLayerStorage;
import cn.nukkit.level.format.anvil.util.BlockStorage;
import cn.nukkit.level.format.anvil.util.ImmutableBlockStorage;
import cn.nukkit.utils.BinaryStream;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public final class SingleLayerStorage
extends LayerStorage {
    private BlockStorage storage;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public SingleLayerStorage() {
        this.storage = ImmutableBlockStorage.EMPTY;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public SingleLayerStorage(BlockStorage storage) {
        this.storage = storage;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean hasBlocks() {
        return this.storage.hasBlockIds();
    }

    @Override
    public SingleLayerStorage clone() {
        SingleLayerStorage clone = (SingleLayerStorage)super.clone();
        clone.storage = clone.storage.copy();
        return clone;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockStorage getStorageOrEmpty(int layer) {
        switch (layer) {
            case 0: {
                return this.storage;
            }
            case 1: {
                return ImmutableBlockStorage.EMPTY;
            }
        }
        throw new IndexOutOfBoundsException("Invalid layer: " + layer);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockStorage getOrSetStorage(Consumer<LayerStorage> setLayerStorage, IntSupplier contentVersion, int layer) {
        switch (layer) {
            case 0: {
                break;
            }
            case 1: {
                BlockStorage blockStorage = this.createBlockStorage(contentVersion.getAsInt());
                MultiLayerStorage multiLayerStorage = new MultiLayerStorage(this.storage, blockStorage);
                setLayerStorage.accept(multiLayerStorage);
                return blockStorage;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid layer: " + layer);
            }
        }
        BlockStorage blockStorage = this.storage;
        if (blockStorage != ImmutableBlockStorage.EMPTY) {
            return blockStorage;
        }
        this.storage = blockStorage = this.createBlockStorage(contentVersion.getAsInt());
        return blockStorage;
    }

    @Override
    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockStorage getStorageOrNull(int layer) {
        if (layer != 0) {
            return null;
        }
        BlockStorage blockStorage = this.storage;
        return blockStorage != ImmutableBlockStorage.EMPTY ? blockStorage : null;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void delayPaletteUpdates() {
        this.storage.delayPaletteUpdates();
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void writeTo(BinaryStream stream) {
        stream.putByte((byte)8);
        BlockStorage blockStorage = this.storage;
        if (blockStorage == ImmutableBlockStorage.EMPTY) {
            stream.putByte((byte)0);
            return;
        }
        stream.putByte((byte)1);
        blockStorage.writeTo(stream);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int size() {
        return this.storage == ImmutableBlockStorage.EMPTY ? 0 : 1;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void compress(Consumer<LayerStorage> setLayerStorage) {
        BlockStorage blockStorage = this.storage;
        if (blockStorage == ImmutableBlockStorage.EMPTY) {
            setLayerStorage.accept(EMPTY);
            return;
        }
        blockStorage.recheckBlocks();
        if (!blockStorage.hasBlockIds()) {
            setLayerStorage.accept(EMPTY);
        }
    }
}

