/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.generic;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockUnknown;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.Chunk;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.level.format.updater.ChunkUpdater;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.utils.ChunkException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseChunk
extends BaseFullChunk
implements Chunk {
    @Generated
    private static final Logger log = LogManager.getLogger(BaseChunk.class);
    private boolean delayPaletteUpdates;
    protected ChunkSection[] sections;

    @Override
    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.0.0-PN")
    public void backwardCompatibilityUpdate(Level level) {
        ChunkUpdater.backwardCompatibilityUpdate(level, this);
    }

    @Override
    public BaseChunk clone() {
        BaseChunk chunk = (BaseChunk)super.clone();
        if (this.biomes != null) {
            chunk.biomes = (byte[])this.biomes.clone();
        }
        chunk.heightMap = (byte[])this.getHeightMapArray().clone();
        if (this.sections != null && this.sections[0] != null) {
            chunk.sections = new ChunkSection[this.sections.length];
            for (int i = 0; i < this.sections.length; ++i) {
                chunk.sections[i] = this.sections[i].copy();
            }
        }
        return chunk;
    }

    private void removeInvalidTile(int x, int y, int z) {
        BlockEntity entity = this.getTile(x, y, z);
        if (entity != null) {
            try {
                if (!entity.closed && entity.isBlockEntityValid()) {
                    return;
                }
            }
            catch (Exception e) {
                try {
                    log.warn("Block entity validation of {} at {}, {} {} {} failed, removing as invalid.", (Object)entity.getClass().getName(), (Object)this.getProvider().getLevel().getName(), (Object)entity.x, (Object)entity.y, (Object)entity.z, (Object)e);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    log.warn("Block entity validation failed", (Throwable)e);
                }
            }
            this.removeBlockEntity(entity);
        }
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Stream<Block> scanBlocks(BlockVector3 min, BlockVector3 max, BiPredicate<BlockVector3, BlockState> condition) {
        int offsetX = this.getX() << 4;
        int offsetZ = this.getZ() << 4;
        return ((Stream)IntStream.rangeClosed(min.getChunkSectionY(), max.getChunkSectionY()).filter(sectionY -> sectionY >= 0 && sectionY < this.sections.length).mapToObj(sectionY -> this.sections[sectionY]).filter(section -> !section.isEmpty()).parallel()).map(section -> section.scanBlocks(this.getProvider(), offsetX, offsetZ, min, max, condition)).flatMap(Collection::stream);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(x, y, z, 0);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getFullBlock(int x, int y, int z, int layer) {
        return this.sections[y >> 4].getFullBlock(x, y & 0xF, z, layer);
    }

    @Override
    @PowerNukkitOnly
    public BlockState getBlockState(int x, int y, int z, int layer) {
        return this.sections[y >> 4].getBlockState(x, y & 0xF, z, layer);
    }

    @Override
    @PowerNukkitOnly
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId) {
        return this.setBlockStateAtLayer(x, y, z, layer, BlockState.of(blockId));
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId) {
        return this.setBlockState(x, y, z, BlockState.of(blockId));
    }

    @Override
    public Block getAndSetBlock(int x, int y, int z, Block block) {
        return this.getAndSetBlock(x, y, z, 0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getAndSetBlockState(int x, int y, int z, int layer, BlockState state) {
        int sectionY = y >> 4;
        try {
            this.setChanged();
            BlockState blockState = this.getOrCreateMutableSection(sectionY).getAndSetBlockState(x, y & 0xF, z, layer, state);
            return blockState;
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    @PowerNukkitOnly
    public Block getAndSetBlock(int x, int y, int z, int layer, Block block) {
        BlockState state = this.getAndSetBlockState(x, y, z, layer, block.getCurrentState());
        try {
            return state.getBlock();
        }
        catch (InvalidBlockStateException e) {
            return new BlockUnknown(state.getBlockId(), (Integer)state.getExactIntStorage());
        }
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public boolean setFullBlockId(int x, int y, int z, int fullId) {
        return this.setFullBlockId(x, y, z, 0, fullId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean setFullBlockId(int x, int y, int z, int layer, int fullId) {
        int sectionY = y >> 4;
        try {
            this.setChanged();
            boolean bl = this.getOrCreateMutableSection(sectionY).setFullBlockId(x, y & 0xF, z, layer, fullId);
            return bl;
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public boolean setBlock(int x, int y, int z, int blockId, int meta) {
        return this.setBlockAtLayer(x, y, z, 0, blockId, meta);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId, int meta) {
        return this.setBlockStateAtLayer(x, y, z, layer, BlockState.of(blockId, meta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setBlockStateAtLayer(int x, int y, int z, int layer, BlockState state) {
        int sectionY = y >> 4;
        try {
            this.setChanged();
            boolean bl = this.getOrCreateMutableSection(sectionY).setBlockStateAtLayer(x, y & 0xF, z, layer, state);
            return bl;
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    private ChunkSection getOrCreateMutableSection(int sectionY) {
        ChunkSection section = this.sections[sectionY];
        if (section.isEmpty()) {
            this.createChunkSection(sectionY);
            return this.sections[sectionY];
        }
        return section;
    }

    private void createChunkSection(int sectionY) {
        try {
            this.setInternalSection(sectionY, (ChunkSection)this.providerClass.getMethod("createChunkSection", Integer.TYPE).invoke((Object)this.providerClass, sectionY));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to create ChunkSection", (Throwable)e);
            throw new ChunkException(e);
        }
    }

    @Override
    public void setBlockId(int x, int y, int z, int id) {
        this.setBlockStateAtLayer(x, y, z, 0, BlockState.of(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockId(int x, int y, int z, int layer, int id) {
        int sectionY = y >> 4;
        try {
            this.setChanged();
            this.getOrCreateMutableSection(sectionY).setBlockId(x, y & 0xF, z, layer, id);
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.getBlockId(x, y, z, 0);
    }

    @Override
    @PowerNukkitOnly
    public int getBlockId(int x, int y, int z, int layer) {
        return this.sections[y >> 4].getBlockId(x, y & 0xF, z, layer);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public int getBlockData(int x, int y, int z) {
        return this.getBlockData(x, y, z, 0);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getBlockData(int x, int y, int z, int layer) {
        return this.sections[y >> 4].getBlockData(x, y & 0xF, z, layer);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public void setBlockData(int x, int y, int z, int data) {
        this.setBlockData(x, y, z, 0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockData(int x, int y, int z, int layer, int data) {
        int sectionY = y >> 4;
        try {
            this.setChanged();
            this.getOrCreateMutableSection(sectionY).setBlockData(x, y & 0xF, z, layer, data);
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    public int getBlockSkyLight(int x, int y, int z) {
        return this.sections[y >> 4].getBlockSkyLight(x, y & 0xF, z);
    }

    @Override
    public void setBlockSkyLight(int x, int y, int z, int level) {
        int sectionY = y >> 4;
        this.getOrCreateMutableSection(sectionY).setBlockSkyLight(x, y & 0xF, z, level);
        this.setChanged();
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.sections[y >> 4].getBlockLight(x, y & 0xF, z);
    }

    @Override
    public void setBlockLight(int x, int y, int z, int level) {
        int sectionY = y >> 4;
        this.getOrCreateMutableSection(sectionY).setBlockLight(x, y & 0xF, z, level);
        this.setChanged();
    }

    @Override
    public boolean isSectionEmpty(float fY) {
        return this.sections[(int)fY].isEmpty();
    }

    @Override
    public ChunkSection getSection(float fY) {
        return this.sections[(int)fY];
    }

    @Override
    public boolean setSection(float fY, ChunkSection section) {
        this.sections[(int)fY] = !section.hasBlocks() ? EmptyChunkSection.EMPTY[(int)fY] : section;
        this.setChanged();
        return true;
    }

    private void setInternalSection(float fY, ChunkSection section) {
        if (this.isPaletteUpdatesDelayed()) {
            section.delayPaletteUpdates();
        }
        this.sections[(int)fY] = section;
        this.setChanged();
    }

    @Override
    public boolean load() throws IOException {
        return this.load(true);
    }

    @Override
    public boolean load(boolean generate) throws IOException {
        return this.getProvider() != null && this.getProvider().getChunk(this.getX(), this.getZ(), true) != null;
    }

    @Override
    public byte[] getBlockSkyLightArray() {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        for (int y = 0; y < 16; ++y) {
            buffer.put(this.sections[y].getSkyLightArray());
        }
        return buffer.array();
    }

    @Override
    public byte[] getBlockLightArray() {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        for (int y = 0; y < 16; ++y) {
            buffer.put(this.sections[y].getLightArray());
        }
        return buffer.array();
    }

    @Override
    public ChunkSection[] getSections() {
        return this.sections;
    }

    @Override
    public byte[] getHeightMapArray() {
        return this.heightMap;
    }

    @Override
    public LevelProvider getProvider() {
        return this.provider;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setBlockStateAt(int x, int y, int z, int layer, BlockState state) {
        return this.setBlockStateAtLayer(x & 0xF, y, z & 0xF, layer, state);
    }

    @Override
    @PowerNukkitOnly
    public BlockState getBlockStateAt(int x, int y, int z, int layer) {
        return this.getBlockState(x & 0xF, y, z & 0xF, layer);
    }

    @Override
    @PowerNukkitOnly
    public boolean isBlockChangeAllowed(int x, int y, int z) {
        for (ChunkSection section : this.sections) {
            if (section.getBlockChangeStateAbove(x, 0, z) != 3) continue;
            return false;
        }
        if (y <= 0) {
            return this.sections[0].getBlockChangeStateAbove(x, 0, z) == 0;
        }
        int sectionY = y >> 4;
        y &= 0xF;
        while (sectionY >= 0) {
            switch (this.sections[sectionY].getBlockChangeStateAbove(x, y, z)) {
                case 1: 
                case 3: {
                    return false;
                }
                case 2: {
                    if (sectionY == y >> 4) {
                        return this.sections[sectionY].getBlockId(x, y, z, 0) != 210;
                    }
                    return true;
                }
            }
            y = 15;
            --sectionY;
        }
        return true;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public List<Block> findBorders(int x, int z) {
        List<Block> borders = null;
        for (ChunkSection section : this.sections) {
            if (section.getBlockChangeStateAbove(x, 0, z) != 3) continue;
            for (int y = 0; y < 15; ++y) {
                BlockState blockState = section.getBlockState(x, y, z, 0);
                if (blockState.getBlockId() != 212) continue;
                if (borders == null) {
                    borders = new ArrayList<Block>(3);
                }
                borders.add(blockState.getBlock(this.provider.getLevel(), x, y, z, 0));
            }
        }
        return borders != null ? borders : Collections.emptyList();
    }

    @Override
    @PowerNukkitOnly
    public boolean isBlockedByBorder(int x, int z) {
        for (ChunkSection section : this.sections) {
            if (section.getBlockChangeStateAbove(x, 0, z) != 3) continue;
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void delayPaletteUpdates() {
        ChunkSection[] sections = this.sections;
        if (sections != null) {
            for (ChunkSection section : sections) {
                if (section == null) continue;
                section.delayPaletteUpdates();
            }
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isPaletteUpdatesDelayed() {
        return this.delayPaletteUpdates;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPaletteUpdatesDelayed(boolean delayPaletteUpdates) {
        this.delayPaletteUpdates = delayPaletteUpdates;
        if (delayPaletteUpdates) {
            this.delayPaletteUpdates();
        }
    }
}

