/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.updater.Updater;
import cn.nukkit.math.BlockFace;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BeehiveUpdater
implements Updater {
    private final ChunkSection section;
    private boolean updateDirection;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BeehiveUpdater(ChunkSection section, boolean updateDirection) {
        this.section = section;
        this.updateDirection = updateDirection;
    }

    @Override
    @PowerNukkitOnly
    public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, BlockState state) {
        int blockId = state.getBlockId();
        if (blockId == 474 || blockId == 473) {
            int newMeta;
            int honeyLevel;
            BlockFace face;
            int meta = state.getLegacyDamage();
            if (this.updateDirection) {
                face = BlockFace.fromIndex(meta & 7);
                honeyLevel = meta >> 3 & 7;
            } else {
                face = BlockFace.fromHorizontalIndex(meta & 3);
                honeyLevel = meta >> 2 & 7;
            }
            if (honeyLevel > 5) {
                honeyLevel = 5;
            }
            if ((newMeta = honeyLevel << 2 | face.getHorizontalIndex()) != meta) {
                this.section.setBlockState(x, y, z, state.withData(newMeta));
                return true;
            }
        }
        return false;
    }
}

