/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.updater.Updater;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class StemStrippedUpdater
implements Updater {
    private final ChunkSection section;
    private final BlockProperties oldProperties = new BlockProperties(CommonBlockProperties.PILLAR_AXIS, CommonBlockProperties.DEPRECATED);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public StemStrippedUpdater(ChunkSection section) {
        this.section = section;
    }

    @Override
    @PowerNukkitOnly
    public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, BlockState state) {
        switch (state.getBlockId()) {
            case 495: 
            case 496: 
            case 555: 
            case 556: {
                break;
            }
            default: {
                return false;
            }
        }
        int currentStorage = state.getExactIntStorage();
        if (this.oldProperties.getIntValue(currentStorage, CommonBlockProperties.DEPRECATED.getName()) == 0) {
            return false;
        }
        int newStorage = this.oldProperties.setIntValue(currentStorage, CommonBlockProperties.DEPRECATED.getName(), 0);
        this.section.setBlockState(x, y, z, state.withData(newStorage));
        return true;
    }
}

