/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.generic.BaseFullChunk;

public abstract class SimpleChunkManager
implements ChunkManager {
    protected long seed;

    public SimpleChunkManager(long seed) {
        this.seed = seed;
    }

    @Override
    public int getBlockIdAt(int x, int y, int z) {
        return this.getBlockIdAt(x, y, z, 0);
    }

    @Override
    @PowerNukkitOnly
    public int getBlockIdAt(int x, int y, int z, int layer) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null) {
            return chunk.getBlockId(x & 0xF, y & 0xFF, z & 0xF, layer);
        }
        return 0;
    }

    @Override
    @PowerNukkitOnly
    public BlockState getBlockStateAt(int x, int y, int z, int layer) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null) {
            return chunk.getBlockState(x & 0xF, y & 0xFF, z & 0xF, layer);
        }
        return BlockState.AIR;
    }

    @Override
    public void setBlockIdAt(int x, int y, int z, int id) {
        this.setBlockIdAt(x, y, z, 0, id);
    }

    @Override
    @PowerNukkitOnly
    public void setBlockIdAt(int x, int y, int z, int layer, int id) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null) {
            chunk.setBlockId(x & 0xF, y & 0xFF, z & 0xF, layer, id);
        }
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public void setBlockAt(int x, int y, int z, int id, int data) {
        this.setBlockAtLayer(x, y, z, 0, id, data);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int id, int data) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null) {
            return chunk.setBlockAtLayer(x & 0xF, y & 0xFF, z & 0xF, layer, id, data);
        }
        return false;
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public void setBlockFullIdAt(int x, int y, int z, int fullId) {
        this.setBlockFullIdAt(x, y, z, 0, fullId);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockFullIdAt(int x, int y, int z, int layer, int fullId) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null) {
            chunk.setFullBlockId(x & 0xF, y & 0xFF, z & 0xF, layer, fullId);
        }
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setBlockStateAt(int x, int y, int z, int layer, BlockState state) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null) {
            return chunk.setBlockStateAtLayer(x & 0xF, y & 0xFF, z & 0xF, layer, state);
        }
        return false;
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public int getBlockDataAt(int x, int y, int z) {
        return this.getBlockDataAt(x, y, z, 0);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getBlockDataAt(int x, int y, int z, int layer) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null) {
            return chunk.getBlockData(x & 0xF, y & 0xFF, z & 0xF, layer);
        }
        return 0;
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public void setBlockDataAt(int x, int y, int z, int data) {
        this.setBlockDataAt(x, y, z, data, 0);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockDataAt(int x, int y, int z, int layer, int data) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null) {
            chunk.setBlockData(x & 0xF, y & 0xFF, z & 0xF, layer, data);
        }
    }

    @Override
    public void setChunk(int chunkX, int chunkZ) {
        this.setChunk(chunkX, chunkZ, null);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void cleanChunks(long seed) {
        this.seed = seed;
    }
}

