/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.particle;

import cn.nukkit.item.Item;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.LevelEventPacket;

public class ItemBreakParticle
extends Particle {
    private final int data;

    public ItemBreakParticle(Vector3 pos, Item item) {
        super(pos.x, pos.y, pos.z);
        this.data = item.getNetworkId() << 16 | item.getDamage();
    }

    @Override
    public DataPacket[] encode() {
        LevelEventPacket packet = new LevelEventPacket();
        packet.evid = (short)(0x4000 | Particle.TYPE_ITEM_BREAK);
        packet.x = (float)this.x;
        packet.y = (float)this.y;
        packet.z = (float)this.z;
        packet.data = this.data;
        return new DataPacket[]{packet};
    }
}

