/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.math.CompassRoseDirection;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;

public enum BlockFace {
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, new Vector3(0.0, -1.0, 0.0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, new Vector3(0.0, 1.0, 0.0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, new Vector3(0.0, 0.0, -1.0)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, new Vector3(0.0, 0.0, 1.0)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, new Vector3(-1.0, 0.0, 0.0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, new Vector3(1.0, 0.0, 0.0));

    private static final BlockFace[] VALUES;
    private static final BlockFace[] HORIZONTALS;
    private final int index;
    private final int opposite;
    private final int horizontalIndex;
    private final String name;
    private Axis axis;
    private final AxisDirection axisDirection;
    private final Vector3 unitVector;

    private BlockFace(int index, int opposite, int horizontalIndex, String name, AxisDirection axisDirection, Vector3 unitVector) {
        this.index = index;
        this.opposite = opposite;
        this.horizontalIndex = horizontalIndex;
        this.name = name;
        this.axisDirection = axisDirection;
        this.unitVector = unitVector;
    }

    public static BlockFace fromIndex(int index) {
        return VALUES[MathHelper.abs(index % VALUES.length)];
    }

    public static BlockFace fromHorizontalIndex(int index) {
        return HORIZONTALS[MathHelper.abs(index % HORIZONTALS.length)];
    }

    public static BlockFace fromHorizontalAngle(double angle) {
        return BlockFace.fromHorizontalIndex(NukkitMath.floorDouble(angle / 90.0 + 0.5) & 3);
    }

    public static BlockFace fromAxis(AxisDirection axisDirection, Axis axis) {
        for (BlockFace face : VALUES) {
            if (face.getAxisDirection() != axisDirection || face.getAxis() != axis) continue;
            return face;
        }
        throw new RuntimeException("Unable to get face from axis: " + (Object)((Object)axisDirection) + " " + axis);
    }

    public static BlockFace random(Random rand) {
        return VALUES[rand.nextInt(VALUES.length)];
    }

    public int getIndex() {
        return this.index;
    }

    public int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public float getHorizontalAngle() {
        return (this.horizontalIndex & 3) * 90;
    }

    public String getName() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public Vector3 getUnitVector() {
        return this.unitVector;
    }

    public int getXOffset() {
        return this.axis == Axis.X ? this.axisDirection.getOffset() : 0;
    }

    public int getYOffset() {
        return this.axis == Axis.Y ? this.axisDirection.getOffset() : 0;
    }

    public int getZOffset() {
        return this.axis == Axis.Z ? this.axisDirection.getOffset() : 0;
    }

    public BlockFace getOpposite() {
        return BlockFace.fromIndex(this.opposite);
    }

    public BlockFace rotateY() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        throw new RuntimeException("Unable to get Y-rotated face of " + (Object)((Object)this));
    }

    public BlockFace rotateYCCW() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        throw new RuntimeException("Unable to get counter-clockwise Y-rotated face of " + (Object)((Object)this));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public CompassRoseDirection getCompassRoseDirection() {
        switch (this) {
            case NORTH: {
                return CompassRoseDirection.NORTH;
            }
            case SOUTH: {
                return CompassRoseDirection.SOUTH;
            }
            case WEST: {
                return CompassRoseDirection.WEST;
            }
            case EAST: {
                return CompassRoseDirection.EAST;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALUES = new BlockFace[6];
        HORIZONTALS = new BlockFace[4];
        BlockFace.DOWN.axis = Axis.Y;
        BlockFace.UP.axis = Axis.Y;
        BlockFace.NORTH.axis = Axis.Z;
        BlockFace.SOUTH.axis = Axis.Z;
        BlockFace.WEST.axis = Axis.X;
        BlockFace.EAST.axis = Axis.X;
        BlockFace[] blockFaceArray = BlockFace.values();
        int n = blockFaceArray.length;
        for (int i = 0; i < n; ++i) {
            BlockFace face;
            BlockFace.VALUES[face.index] = face = blockFaceArray[i];
            if (!face.getAxis().isHorizontal()) continue;
            BlockFace.HORIZONTALS[face.horizontalIndex] = face;
        }
    }

    public static enum Plane implements Predicate<BlockFace>,
    Iterable<BlockFace>
    {
        HORIZONTAL,
        VERTICAL;

        private BlockFace[] faces;

        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        public BlockFace random() {
            return this.faces[ThreadLocalRandom.current().nextInt(this.faces.length)];
        }

        public BlockFace random(NukkitRandom rand) {
            return this.faces[rand.nextBoundedInt(this.faces.length)];
        }

        @Override
        public boolean test(BlockFace face) {
            return face != null && face.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<BlockFace> iterator() {
            return Iterators.forArray((Object[])this.faces);
        }

        static {
            Plane.HORIZONTAL.faces = new BlockFace[]{NORTH, EAST, SOUTH, WEST};
            Plane.VERTICAL.faces = new BlockFace[]{UP, DOWN};
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int offset;
        private final String description;

        private AxisDirection(int offset, String description) {
            this.offset = offset;
            this.description = description;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Axis implements Predicate<BlockFace>
    {
        X("x"),
        Y("y"),
        Z("z");

        private final String name;
        private Plane plane;

        private Axis(String name) {
            this.name = name;
        }

        public boolean isVertical() {
            return this.plane == Plane.VERTICAL;
        }

        public boolean isHorizontal() {
            return this.plane == Plane.HORIZONTAL;
        }

        public Plane getPlane() {
            return this.plane;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean test(BlockFace face) {
            return face != null && face.getAxis() == this;
        }

        public String toString() {
            return this.name;
        }

        static {
            Axis.X.plane = Plane.HORIZONTAL;
            Axis.Y.plane = Plane.VERTICAL;
            Axis.Z.plane = Plane.HORIZONTAL;
        }
    }
}

