/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.nbt.tag;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.nbt.stream.NBTInputStream;
import cn.nukkit.nbt.stream.NBTOutputStream;
import cn.nukkit.nbt.tag.ByteArrayTag;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.IntArrayTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.LongTag;
import cn.nukkit.nbt.tag.NumberTag;
import cn.nukkit.nbt.tag.ShortTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import io.netty.util.internal.EmptyArrays;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompoundTag
extends Tag
implements Cloneable {
    private final Map<String, Tag> tags;

    public CompoundTag() {
        this("");
    }

    public CompoundTag(String name) {
        this(name, new HashMap<String, Tag>());
    }

    @PowerNukkitOnly
    public CompoundTag(Map<String, Tag> tags) {
        this("", tags);
    }

    @PowerNukkitOnly
    public CompoundTag(String name, Map<String, Tag> tags) {
        super(name);
        this.tags = tags;
    }

    @Override
    public void write(NBTOutputStream dos) throws IOException {
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            Tag.writeNamedTag(entry.getValue(), entry.getKey(), dos);
        }
        dos.writeByte(0);
    }

    @Override
    public void load(NBTInputStream dis) throws IOException {
        Tag tag;
        this.tags.clear();
        while ((tag = Tag.readNamedTag(dis)).getId() != 0) {
            this.tags.put(tag.getName(), tag);
        }
    }

    public Collection<Tag> getAllTags() {
        return this.tags.values();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public CompoundTag put(String name, Tag tag) {
        this.tags.put(name, tag.setName(name));
        return this;
    }

    public CompoundTag putByte(String name, int value) {
        this.tags.put(name, new ByteTag(name, value));
        return this;
    }

    public CompoundTag putShort(String name, int value) {
        this.tags.put(name, new ShortTag(name, value));
        return this;
    }

    public CompoundTag putInt(String name, int value) {
        this.tags.put(name, new IntTag(name, value));
        return this;
    }

    public CompoundTag putLong(String name, long value) {
        this.tags.put(name, new LongTag(name, value));
        return this;
    }

    public CompoundTag putFloat(String name, float value) {
        this.tags.put(name, new FloatTag(name, value));
        return this;
    }

    public CompoundTag putDouble(String name, double value) {
        this.tags.put(name, new DoubleTag(name, value));
        return this;
    }

    public CompoundTag putString(@Nullable String name, @Nonnull String value) {
        this.tags.put(name, new StringTag(name, value));
        return this;
    }

    public CompoundTag putByteArray(String name, byte[] value) {
        this.tags.put(name, new ByteArrayTag(name, value));
        return this;
    }

    public CompoundTag putIntArray(String name, int[] value) {
        this.tags.put(name, new IntArrayTag(name, value));
        return this;
    }

    public CompoundTag putList(ListTag<? extends Tag> listTag) {
        this.tags.put(listTag.getName(), listTag);
        return this;
    }

    public CompoundTag putCompound(String name, CompoundTag value) {
        this.tags.put(name, value.setName(name));
        return this;
    }

    public CompoundTag putBoolean(String string, boolean val) {
        this.putByte(string, val ? 1 : 0);
        return this;
    }

    public Tag get(String name) {
        return this.tags.get(name);
    }

    public boolean contains(String name) {
        return this.tags.containsKey(name);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsCompound(String name) {
        return this.tags.get(name) instanceof CompoundTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsString(String name) {
        return this.tags.get(name) instanceof StringTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsIntArray(String name) {
        return this.tags.get(name) instanceof IntArrayTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsByteArray(String name) {
        return this.tags.get(name) instanceof ByteArrayTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsNumber(String name) {
        return this.tags.get(name) instanceof NumberTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsList(String name) {
        return this.tags.get(name) instanceof ListTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsList(String name, byte type) {
        Tag tag = this.tags.get(name);
        if (!(tag instanceof ListTag)) {
            return false;
        }
        ListTag list = (ListTag)tag;
        byte listType = list.type;
        return listType == 0 || listType == type;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsByte(String name) {
        return this.tags.get(name) instanceof ByteTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsShort(String name) {
        return this.tags.get(name) instanceof ShortTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsInt(String name) {
        return this.tags.get(name) instanceof IntTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsDouble(String name) {
        return this.tags.get(name) instanceof DoubleTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean containsFloat(String name) {
        return this.tags.get(name) instanceof FloatTag;
    }

    public CompoundTag remove(String name) {
        this.tags.remove(name);
        return this;
    }

    public <T extends Tag> T removeAndGet(String name) {
        return (T)this.tags.remove(name);
    }

    public int getByte(String name) {
        if (!this.tags.containsKey(name)) {
            return 0;
        }
        return ((Number)((NumberTag)this.tags.get(name)).getData()).intValue();
    }

    public int getShort(String name) {
        if (!this.tags.containsKey(name)) {
            return 0;
        }
        return ((Number)((NumberTag)this.tags.get(name)).getData()).intValue();
    }

    public int getInt(String name) {
        if (!this.tags.containsKey(name)) {
            return 0;
        }
        return ((Number)((NumberTag)this.tags.get(name)).getData()).intValue();
    }

    public long getLong(String name) {
        if (!this.tags.containsKey(name)) {
            return 0L;
        }
        return ((Number)((NumberTag)this.tags.get(name)).getData()).longValue();
    }

    public float getFloat(String name) {
        if (!this.tags.containsKey(name)) {
            return 0.0f;
        }
        return ((Number)((NumberTag)this.tags.get(name)).getData()).floatValue();
    }

    public double getDouble(String name) {
        if (!this.tags.containsKey(name)) {
            return 0.0;
        }
        return ((Number)((NumberTag)this.tags.get(name)).getData()).doubleValue();
    }

    public String getString(String name) {
        if (!this.tags.containsKey(name)) {
            return "";
        }
        Tag tag = this.tags.get(name);
        if (tag instanceof NumberTag) {
            return String.valueOf(((NumberTag)tag).getData());
        }
        return ((StringTag)tag).data;
    }

    public byte[] getByteArray(String name) {
        if (!this.tags.containsKey(name)) {
            return EmptyArrays.EMPTY_BYTES;
        }
        return ((ByteArrayTag)this.tags.get((Object)name)).data;
    }

    public int[] getIntArray(String name) {
        if (!this.tags.containsKey(name)) {
            return EmptyArrays.EMPTY_INTS;
        }
        return ((IntArrayTag)this.tags.get((Object)name)).data;
    }

    public CompoundTag getCompound(String name) {
        if (!this.tags.containsKey(name)) {
            return new CompoundTag(name);
        }
        return (CompoundTag)this.tags.get(name);
    }

    public ListTag<? extends Tag> getList(String name) {
        if (!this.tags.containsKey(name)) {
            return new ListTag(name);
        }
        return (ListTag)this.tags.get(name);
    }

    public <T extends Tag> ListTag<T> getList(String name, Class<T> type) {
        if (this.tags.containsKey(name)) {
            return (ListTag)this.tags.get(name);
        }
        return new ListTag(name);
    }

    public Map<String, Tag> getTags() {
        return new HashMap<String, Tag>(this.tags);
    }

    @Override
    public Map<String, Object> parseValue() {
        HashMap<String, Object> value = new HashMap<String, Object>(this.tags.size());
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            value.put(entry.getKey(), entry.getValue().parseValue());
        }
        return value;
    }

    public boolean getBoolean(String name) {
        return this.getByte(name) != 0;
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(",\n\t");
        this.tags.forEach((key, tag) -> joiner.add('\'' + key + "' : " + tag.toString().replace("\n", "\n\t")));
        return "CompoundTag '" + this.getName() + "' (" + this.tags.size() + " entries) {\n\t" + joiner.toString() + "\n}";
    }

    @Override
    public void print(String prefix, PrintStream out) {
        super.print(prefix, out);
        out.println(prefix + "{");
        String orgPrefix = prefix;
        prefix = prefix + "   ";
        for (Tag tag : this.tags.values()) {
            tag.print(prefix, out);
        }
        out.println(orgPrefix + "}");
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public CompoundTag copy() {
        CompoundTag tag = new CompoundTag(this.getName());
        for (String key : this.tags.keySet()) {
            tag.put(key, this.tags.get(key).copy());
        }
        return tag;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            CompoundTag o = (CompoundTag)obj;
            return this.tags.entrySet().equals(o.tags.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tags);
    }

    public boolean exist(String name) {
        return this.tags.containsKey(name);
    }

    public CompoundTag clone() {
        CompoundTag nbt = new CompoundTag();
        this.getTags().forEach((key, value) -> nbt.put((String)key, value.copy()));
        return nbt;
    }
}

