/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.utils.Utils;
import io.netty.util.internal.EmptyArrays;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import lombok.Generated;

public class ClientboundMapItemDataPacket
extends DataPacket {
    public int[] eids = EmptyArrays.EMPTY_INTS;
    public long mapId;
    public int update;
    public byte scale;
    public boolean isLocked;
    public int width;
    public int height;
    public int offsetX;
    public int offsetZ;
    public byte dimensionId;
    public MapDecorator[] decorators = MapDecorator.EMPTY_ARRAY;
    public int[] colors = EmptyArrays.EMPTY_INTS;
    public BufferedImage image = null;
    public static final int TEXTURE_UPDATE = 2;
    public static final int DECORATIONS_UPDATE = 4;
    public static final int ENTITIES_UPDATE = 8;

    @Override
    public byte pid() {
        return 67;
    }

    @Override
    public void decode() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void encode() {
        this.reset();
        this.putEntityUniqueId(this.mapId);
        int update = 0;
        if (this.eids.length > 0) {
            update |= 8;
        }
        if (this.decorators.length > 0) {
            update |= 4;
        }
        if (this.image != null || this.colors.length > 0) {
            update |= 2;
        }
        this.putUnsignedVarInt(update);
        this.putByte(this.dimensionId);
        this.putBoolean(this.isLocked);
        if ((update & 8) != 0) {
            this.putUnsignedVarInt(this.eids.length);
            for (int eid : this.eids) {
                this.putEntityUniqueId(eid);
            }
        }
        if ((update & 6) != 0) {
            this.putByte(this.scale);
        }
        if ((update & 4) != 0) {
            this.putUnsignedVarInt(this.decorators.length);
            for (MapDecorator decorator : this.decorators) {
                this.putByte(decorator.rotation);
                this.putByte(decorator.icon);
                this.putByte(decorator.offsetX);
                this.putByte(decorator.offsetZ);
                this.putString(decorator.label);
                this.putVarInt(decorator.color.getRGB());
            }
        }
        if ((update & 2) != 0) {
            this.putVarInt(this.width);
            this.putVarInt(this.height);
            this.putVarInt(this.offsetX);
            this.putVarInt(this.offsetZ);
            this.putUnsignedVarInt(this.width * this.height);
            if (this.image != null) {
                void var2_6;
                boolean bl = false;
                while (var2_6 < this.width) {
                    for (int x = 0; x < this.height; ++x) {
                        this.putUnsignedVarInt(Utils.toABGR(this.image.getRGB(x, (int)var2_6)));
                    }
                    ++var2_6;
                }
                this.image.flush();
            } else if (this.colors.length > 0) {
                for (int color : this.colors) {
                    this.putUnsignedVarInt(color);
                }
            }
        }
    }

    @Generated
    public String toString() {
        return "ClientboundMapItemDataPacket(eids=" + Arrays.toString(this.eids) + ", mapId=" + this.mapId + ", update=" + this.update + ", scale=" + this.scale + ", isLocked=" + this.isLocked + ", width=" + this.width + ", height=" + this.height + ", offsetX=" + this.offsetX + ", offsetZ=" + this.offsetZ + ", dimensionId=" + this.dimensionId + ", decorators=" + Arrays.deepToString(this.decorators) + ", colors=" + Arrays.toString(this.colors) + ", image=" + this.image + ")";
    }

    public static class MapDecorator {
        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        public static final MapDecorator[] EMPTY_ARRAY = new MapDecorator[0];
        public byte rotation;
        public byte icon;
        public byte offsetX;
        public byte offsetZ;
        public String label;
        public Color color;
    }
}

