/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.DataPacket;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import lombok.Generated;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class PositionTrackingDBServerBroadcastPacket
extends DataPacket {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final byte NETWORK_ID = -103;
    private static final Action[] ACTIONS = Action.values();
    private Action action;
    private int trackingId;
    private CompoundTag tag;

    private CompoundTag requireTag() {
        if (this.tag == null) {
            this.tag = new CompoundTag().putByte("version", 1).putString("id", String.format("0x%08x", this.trackingId));
        }
        return this.tag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setAction(Action action) {
        this.action = action;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTrackingId(int trackingId) {
        this.trackingId = trackingId;
        if (this.tag != null) {
            this.tag.putString("id", String.format("0x%08x", trackingId));
        }
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockVector3 getPosition() {
        if (this.tag == null) {
            return null;
        }
        ListTag<IntTag> pos = this.tag.getList("pos", IntTag.class);
        if (pos == null || pos.size() != 3) {
            return null;
        }
        return new BlockVector3(pos.get((int)0).data, pos.get((int)1).data, pos.get((int)2).data);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPosition(BlockVector3 position) {
        this.setPosition(position.x, position.y, position.z);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPosition(Vector3 position) {
        this.setPosition(position.getFloorX(), position.getFloorY(), position.getFloorZ());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPosition(int x, int y, int z) {
        this.requireTag().putList(new ListTag<IntTag>("pos").add(new IntTag("", x)).add(new IntTag("", y)).add(new IntTag("", z)));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getStatus() {
        if (this.tag == null) {
            return 0;
        }
        return this.tag.getByte("status");
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setStatus(int status) {
        this.requireTag().putByte("status", status);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getVersion() {
        if (this.tag == null) {
            return 0;
        }
        return this.tag.getByte("version");
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setVersion(int status) {
        this.requireTag().putByte("version", status);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getDimension() {
        if (this.tag == null) {
            return 0;
        }
        return this.tag.getByte("dim");
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setDimension(int dimension) {
        this.requireTag().putInt("dim", dimension);
    }

    @Override
    public void encode() {
        this.reset();
        this.putByte((byte)this.action.ordinal());
        this.putVarInt(this.trackingId);
        try {
            this.put(NBTIO.writeNetwork(this.tag != null ? this.tag : new CompoundTag()));
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    @Override
    public void decode() {
        this.action = ACTIONS[this.getByte()];
        this.trackingId = this.getVarInt();
        try (FastByteArrayInputStream inputStream = new FastByteArrayInputStream(this.get());){
            this.tag = NBTIO.readNetworkCompressed((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    @Override
    public byte pid() {
        return -103;
    }

    @Override
    public PositionTrackingDBServerBroadcastPacket clone() {
        return (PositionTrackingDBServerBroadcastPacket)super.clone();
    }

    @Generated
    public String toString() {
        return "PositionTrackingDBServerBroadcastPacket(action=" + (Object)((Object)this.action) + ", trackingId=" + this.trackingId + ", tag=" + this.tag + ")";
    }

    @PowerNukkitOnly
    @Generated
    public PositionTrackingDBServerBroadcastPacket() {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static enum Action {
        UPDATE,
        DESTROY,
        NOT_FOUND;

    }
}

