/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.scheduler;

import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileWriteTask
extends AsyncTask {
    @Generated
    private static final Logger log = LogManager.getLogger(FileWriteTask.class);
    private final File file;
    private final InputStream contents;

    public FileWriteTask(String path, String contents) {
        this(new File(path), contents);
    }

    public FileWriteTask(String path, byte[] contents) {
        this(new File(path), contents);
    }

    public FileWriteTask(String path, InputStream contents) {
        this.file = new File(path);
        this.contents = contents;
    }

    public FileWriteTask(File file, String contents) {
        this.file = file;
        this.contents = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
    }

    public FileWriteTask(File file, byte[] contents) {
        this.file = file;
        this.contents = new ByteArrayInputStream(contents);
    }

    public FileWriteTask(File file, InputStream contents) {
        this.file = file;
        this.contents = contents;
    }

    @Override
    public void onRun() {
        try {
            Utils.writeFile(this.file, this.contents);
        }
        catch (IOException e) {
            log.fatal("An error occurred while writing the file {}", (Object)this.file, (Object)e);
        }
    }
}

