/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import io.netty.util.internal.EmptyArrays;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;

public class SerializedImage {
    public static final SerializedImage EMPTY = new SerializedImage(0, 0, EmptyArrays.EMPTY_BYTES);
    public final int width;
    public final int height;
    public final byte[] data;

    public SerializedImage(int width, int height, byte[] data) {
        this.width = width;
        this.height = height;
        this.data = data;
    }

    public static SerializedImage fromLegacy(byte[] skinData) {
        Objects.requireNonNull(skinData, "skinData");
        switch (skinData.length) {
            case 8192: {
                return new SerializedImage(64, 32, skinData);
            }
            case 16384: {
                return new SerializedImage(64, 64, skinData);
            }
            case 32768: {
                return new SerializedImage(128, 64, skinData);
            }
            case 65536: {
                return new SerializedImage(128, 128, skinData);
            }
        }
        throw new IllegalArgumentException("Unknown legacy skin size");
    }

    @Generated
    public String toString() {
        return "SerializedImage(width=" + this.width + ", height=" + this.height + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializedImage)) {
            return false;
        }
        SerializedImage other = (SerializedImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SerializedImage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.width;
        result = result * 59 + this.height;
        result = result * 59 + Arrays.hashCode(this.data);
        return result;
    }
}

