/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.renderer;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.Chart;
import org.primefaces.component.chart.renderer.BasePlotRenderer;
import org.primefaces.model.chart.DonutChartModel;

public class DonutRenderer
extends BasePlotRenderer {
    @Override
    protected void encodeData(FacesContext context, Chart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DonutChartModel model = (DonutChartModel)chart.getModel();
        List<Map<String, Number>> data = model.getData();
        writer.write(",data:[");
        for (int i = 0; i < data.size(); ++i) {
            if (i != 0) {
                writer.write(",");
            }
            writer.write("[");
            Map<String, Number> map = data.get(i);
            Iterator<Map.Entry<String, Number>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Number> entry = it.next();
                String key = entry.getKey();
                Number value = entry.getValue();
                writer.write("[" + this.escapeChartData(key) + "," + value + "]");
                if (!it.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        writer.write("]");
    }

    @Override
    protected void encodeOptions(FacesContext context, Chart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        DonutChartModel model = (DonutChartModel)chart.getModel();
        int sliceMargin = model.getSliceMargin();
        boolean fill = model.isFill();
        boolean showDataLabels = model.isShowDataLabels();
        String dataFormat = model.getDataFormat();
        String dataLabelFormatString = model.getDataLabelFormatString();
        int dataLabelThreshold = model.getDataLabelThreshold();
        if (sliceMargin != 0) {
            writer.write(",sliceMargin:" + sliceMargin);
        }
        if (!fill) {
            writer.write(",fill:false");
        }
        if (showDataLabels) {
            writer.write(",showDataLabels:true");
        }
        if (dataFormat != null) {
            writer.write(",dataFormat:\"" + dataFormat + "\"");
        }
        if (dataLabelFormatString != null) {
            writer.write(",dataLabelFormatString:\"" + dataLabelFormatString + "\"");
        }
        if (dataLabelThreshold > 0 && dataLabelThreshold < 100) {
            writer.write(",dataLabelThreshold:" + dataLabelThreshold);
        }
        if (model.isShowDatatip()) {
            writer.write(",datatip:true");
            String datatipFormat = model.getDatatipFormat();
            String datatipEditor = model.getDatatipEditor();
            if (datatipFormat != null) {
                writer.write(",datatipFormat:\"" + model.getDatatipFormat() + "\"");
            }
            if (datatipEditor != null) {
                writer.write(",datatipEditor:" + datatipEditor);
            }
        }
    }
}

