/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UISelectMany;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.model.LazyDataModel;
import org.primefaces.util.ComponentUtils;

public abstract class DataTableExporter
implements Exporter<DataTable> {
    private OutputStream outputStream;

    protected List<UIColumn> getColumnsToExport(UIData table) {
        return table.getChildren().stream().filter(UIColumn.class::isInstance).map(UIColumn.class::cast).collect(Collectors.toList());
    }

    protected boolean hasColumnFooter(List<UIColumn> columns) {
        return columns.stream().anyMatch(c -> c.getFooter() != null);
    }

    protected String exportColumnByFunction(FacesContext context, org.primefaces.component.api.UIColumn column) {
        MethodExpression exportFunction = column.getExportFunction();
        if (exportFunction != null) {
            return (String)exportFunction.invoke(context.getELContext(), new Object[]{column});
        }
        return "";
    }

    public String exportValue(FacesContext context, UIComponent component) {
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link = (HtmlCommandLink)component;
            Object value = link.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : link.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (component instanceof ValueHolder) {
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            Converter converter = valueHolder.getConverter();
            if (converter == null) {
                Class<?> valueType = value.getClass();
                converter = context.getApplication().createConverter(valueType);
            }
            if (converter != null) {
                if (component instanceof UISelectMany) {
                    StringBuilder builder = new StringBuilder();
                    List<Object> collection = null;
                    if (value instanceof List) {
                        collection = (List<Object>)value;
                    } else if (value.getClass().isArray()) {
                        collection = Arrays.asList(value);
                    } else {
                        throw new FacesException("Value of " + component.getClientId(context) + " must be a List or an Array.");
                    }
                    int collectionSize = collection.size();
                    for (int i = 0; i < collectionSize; ++i) {
                        Object object = collection.get(i);
                        builder.append(converter.getAsString(context, component, object));
                        if (i >= collectionSize - 1) continue;
                        builder.append(",");
                    }
                    String valuesAsString = builder.toString();
                    builder.setLength(0);
                    return valuesAsString;
                }
                return converter.getAsString(context, component, value);
            }
            return value.toString();
        }
        if (component instanceof CellEditor) {
            return this.exportValue(context, component.getFacet("output"));
        }
        if (component instanceof HtmlGraphicImage) {
            return (String)component.getAttributes().get("alt");
        }
        if (component instanceof OverlayPanel) {
            return "";
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    protected void exportPageOnly(FacesContext context, DataTable table, Object document) {
        int first = table.getFirst();
        int rows = table.getRows();
        if (rows == 0) {
            rows = table.getRowCount();
        }
        int rowsToExport = first + rows;
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, document, rowIndex);
        }
    }

    protected void exportAll(FacesContext context, DataTable table, Object document) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            LazyDataModel lazyDataModel = (LazyDataModel)table.getValue();
            Object wrappedData = lazyDataModel.getWrappedData();
            if (rowCount > 0) {
                table.setFirst(0);
                table.setRows(rowCount);
                table.clearLazyCache();
                table.loadLazyData();
            }
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, document, rowIndex);
            }
            table.setFirst(first);
            table.setRows(rows);
            table.setRowIndex(-1);
            table.clearLazyCache();
            lazyDataModel.setWrappedData(wrappedData);
            lazyDataModel.setPageSize(rows);
            lazyDataModel.setRowIndex(-1);
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, document, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportRow(DataTable table, Object document, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.preRowExport(table, document);
        this.exportCells(table, document);
        this.postRowExport(table, document);
    }

    protected void exportRow(DataTable table, Object document) {
        this.preRowExport(table, document);
        this.exportCells(table, document);
        this.postRowExport(table, document);
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, Object document) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportRow(table, document);
                }
            } else if (Collection.class.isAssignableFrom(selection.getClass())) {
                for (Object obj : (Collection)selection) {
                    requestMap.put(var, obj);
                    this.exportRow(table, document);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, document);
            }
        }
    }

    protected void preExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
    }

    protected void postExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
    }

    protected void preRowExport(DataTable table, Object document) {
    }

    protected void postRowExport(DataTable table, Object document) {
    }

    protected abstract void exportCells(DataTable var1, Object var2);

    @Override
    public void export(FacesContext context, List<DataTable> tables, OutputStream outputStream, ExportConfiguration exportConfiguration) throws IOException {
        this.outputStream = outputStream;
        this.preExport(context, exportConfiguration);
        int index = 0;
        for (DataTable table : tables) {
            DataTableVisitCallBack visitCallback = new DataTableVisitCallBack(table, exportConfiguration, index);
            int nbTables = visitCallback.invoke(context);
            index += nbTables;
        }
        this.postExport(context, exportConfiguration);
        this.outputStream = null;
    }

    protected abstract void doExport(FacesContext var1, DataTable var2, ExportConfiguration var3, int var4) throws IOException;

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    private class DataTableVisitCallBack
    implements VisitCallback {
        private ExportConfiguration config;
        private DataTable target;
        private int index;
        private int counter;

        public DataTableVisitCallBack(DataTable target, ExportConfiguration config, int index) {
            this.target = target;
            this.config = config;
            this.index = index;
        }

        public VisitResult visit(VisitContext context, UIComponent component) {
            if (this.target == component) {
                try {
                    DataTableExporter.this.doExport(context.getFacesContext(), this.target, this.config, this.index);
                    ++this.index;
                    ++this.counter;
                }
                catch (IOException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            return VisitResult.ACCEPT;
        }

        public int invoke(FacesContext context) {
            ComponentUtils.invokeOnClosestIteratorParent((UIComponent)this.target, p -> {
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context);
                p.visitTree(visitContext, (VisitCallback)this);
            }, true);
            return this.counter;
        }
    }

    protected static enum ColumnType {
        HEADER("header"),
        FOOTER("footer");

        private final String facet;

        private ColumnType(String facet) {
            this.facet = facet;
        }

        public String facet() {
            return this.facet;
        }

        public String toString() {
            return this.facet;
        }
    }
}

