/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.util.List;
import java.util.stream.Collectors;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.primefaces.component.fileupload.AbstractFileUploadDecoder;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.model.file.CommonsUploadedFile;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.webapp.MultipartRequest;

public class CommonsFileUploadDecoder
extends AbstractFileUploadDecoder<MultipartRequest> {
    @Override
    public String getName() {
        return "commons";
    }

    @Override
    protected List<UploadedFile> createUploadedFiles(MultipartRequest request, FileUpload fileUpload, String inputToDecodeId) {
        Long sizeLimit = fileUpload.getSizeLimit();
        return request.getFileItems(inputToDecodeId).stream().map(p -> new CommonsUploadedFile((FileItem)p, sizeLimit)).collect(Collectors.toList());
    }

    @Override
    protected UploadedFile createUploadedFile(MultipartRequest request, FileUpload fileUpload, String inputToDecodeId) {
        FileItem file = request.getFileItem(inputToDecodeId);
        if (file != null && !file.getName().isEmpty()) {
            return new CommonsUploadedFile(file, fileUpload.getSizeLimit());
        }
        return null;
    }

    @Override
    protected MultipartRequest getRequest(FacesContext ctxt) {
        MultipartRequest multipartRequest = null;
        Object request = ctxt.getExternalContext().getRequest();
        while (request instanceof ServletRequestWrapper) {
            if (request instanceof MultipartRequest) {
                multipartRequest = (MultipartRequest)((Object)request);
                break;
            }
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return multipartRequest;
    }

    @Override
    public String getUploadDirectory(MultipartRequest request) {
        return request.getUploadDirectory().getAbsolutePath();
    }
}

