/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputlabel;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.metadata.ConstraintDescriptor;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.outputlabel.OutputLabel;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.CompositeUtils;
import org.primefaces.util.EditableValueHolderState;
import org.primefaces.util.HTML;
import org.primefaces.util.SharedStringBuilder;

public class OutputLabelRenderer
extends CoreRenderer {
    private static final Logger LOGGER = Logger.getLogger(OutputLabelRenderer.class.getName());
    private static final String SB_STYLE_CLASS = OutputLabelRenderer.class.getName() + "#styleClass";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        final OutputLabel label = (OutputLabel)component;
        final String clientId = label.getClientId(context);
        final String value = ComponentUtils.getValueToRender(context, (UIComponent)label);
        final StringBuilder styleClass = SharedStringBuilder.get(context, SB_STYLE_CLASS);
        styleClass.append("ui-outputlabel ui-widget");
        if (label.getStyleClass() != null) {
            styleClass.append(" ");
            styleClass.append(label.getStyleClass());
        }
        final EditableValueHolderState state = new EditableValueHolderState();
        final String indicateRequired = label.getIndicateRequired();
        String _for = label.getFor();
        if (!this.isValueBlank(_for)) {
            ContextCallback callback = new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent target) {
                    if (target instanceof InputHolder) {
                        InputHolder inputHolder = (InputHolder)target;
                        state.setClientId(inputHolder.getInputClientId());
                        inputHolder.setLabelledBy(clientId);
                    } else {
                        state.setClientId(target.getClientId(context));
                    }
                    if (target instanceof UIInput) {
                        UIInput input = (UIInput)target;
                        if (value != null && (input.getAttributes().get("label") == null || input.getValueExpression("label") == null)) {
                            ValueExpression ve = label.getValueExpression("value");
                            if (ve != null) {
                                input.setValueExpression("label", ve);
                            } else {
                                String labelString = value;
                                int colonPos = labelString.lastIndexOf(58);
                                if (colonPos != -1) {
                                    labelString = labelString.substring(0, colonPos);
                                }
                                input.getAttributes().put("label", labelString);
                            }
                        }
                        if (!input.isValid()) {
                            styleClass.append(" ui-state-error");
                        }
                        if ("auto".equals(indicateRequired)) {
                            PrimeApplicationContext applicationContext;
                            state.setRequired(input.isRequired());
                            if (!state.isRequired() && (applicationContext = PrimeApplicationContext.getCurrentInstance(context)).getConfig().isBeanValidationEnabled() && OutputLabelRenderer.this.isBeanValidationDefined(input, context)) {
                                state.setRequired(true);
                            }
                        }
                    }
                }
            };
            UIComponent forComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)label, _for);
            if (CompositeUtils.isComposite(forComponent)) {
                CompositeUtils.invokeOnDeepestEditableValueHolder(context, forComponent, callback);
            } else {
                callback.invokeContextCallback(context, forComponent);
            }
        }
        writer.startElement("label", (UIComponent)label);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass.toString(), "id");
        this.renderPassThruAttributes(context, (UIComponent)label, HTML.LABEL_ATTRS);
        this.renderDomEvents(context, (UIComponent)label, HTML.LABEL_EVENTS);
        if (!this.isValueBlank(_for)) {
            writer.writeAttribute("for", (Object)state.getClientId(), "for");
        }
        if (value != null) {
            if (label.isEscape()) {
                writer.writeText((Object)value, "value");
            } else {
                writer.write(value);
            }
        }
        this.renderChildren(context, (UIComponent)label);
        if ("true".equals(indicateRequired) || "auto".equals(indicateRequired) && !this.isValueBlank(_for) && state.isRequired()) {
            this.encodeRequiredIndicator(writer, label);
        }
        writer.endElement("label");
    }

    protected void encodeRequiredIndicator(ResponseWriter writer, OutputLabel label) throws IOException {
        writer.startElement("span", (UIComponent)label);
        writer.writeAttribute("class", (Object)"ui-outputlabel-rfi", null);
        writer.write("*");
        writer.endElement("span");
    }

    protected boolean isBeanValidationDefined(UIInput input, FacesContext context) {
        try {
            PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
            Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extractDefaultConstraintDescriptors(context, applicationContext, ValueExpressionAnalyzer.getExpression(context.getELContext(), input.getValueExpression("value")));
            if (constraints == null || constraints.isEmpty()) {
                return false;
            }
            for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                Class<? extends Annotation> annotationType = constraintDescriptor.getAnnotation().annotationType();
                if (annotationType.equals(NotNull.class) && applicationContext.getConfig().isInterpretEmptyStringAsNull()) {
                    return true;
                }
                String annotationClassName = annotationType.getSimpleName();
                if ("NotBlank".equals(annotationClassName) || "NotEmpty".equals(annotationClassName)) {
                    return true;
                }
                if (!(input instanceof UISelectBoolean) || !annotationType.equals(AssertTrue.class)) continue;
                return true;
            }
        }
        catch (PropertyNotFoundException e) {
            String message = "Skip evaluating [@NotNull,@NotBlank,@NotEmpty,@AssertTrue] for outputLabel and referenced component \"" + input.getClientId(context) + "\" because the ValueExpression of the \"value\" attribute isn't resolvable completely (e.g. a sub-expression returns null)";
            LOGGER.log(Level.FINE, message);
        }
        return false;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

