/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.polarareachart;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.component.polarareachart.PolarAreaChart;
import org.primefaces.model.charts.polar.PolarAreaChartOptions;
import org.primefaces.util.WidgetBuilder;

public class PolarAreaChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PolarAreaChart chart = (PolarAreaChart)component;
        String clientId = chart.getClientId(context);
        String style = chart.getStyle();
        String styleClass = chart.getStyleClass();
        this.encodeMarkup(context, clientId, style, styleClass);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, PolarAreaChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("PolarAreaChart", chart);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        PolarAreaChartOptions polarOptions = (PolarAreaChartOptions)options;
        writer.write(",\"options\":{");
        writer.write("\"animation\":{");
        writer.write("\"animateRotate\":" + polarOptions.isAnimateRotate());
        writer.write(",\"animateScale\":" + polarOptions.isAnimateScale());
        writer.write("}");
        if (polarOptions.getStartAngle() != null) {
            writer.write(",\"startAngle\":" + polarOptions.getStartAngle());
        }
        this.encodeScales(context, type, polarOptions.getScales(), true);
        this.encodeElements(context, polarOptions.getElements(), true);
        this.encodeTitle(context, polarOptions.getTitle(), true);
        this.encodeTooltip(context, polarOptions.getTooltip(), true);
        this.encodeLegend(context, polarOptions.getLegend(), true);
        this.encodeAnimation(context, polarOptions.getAnimation(), true);
        writer.write("}");
    }
}

