/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.primefaces.model.CheckboxTreeNodeChildren;
import org.primefaces.model.TreeNode;

public class CheckboxTreeNode
implements TreeNode,
Serializable {
    public static final String DEFAULT_TYPE = "default";
    private static final long serialVersionUID = 1L;
    private String type;
    private Object data;
    private List<TreeNode> children;
    private TreeNode parent;
    private boolean expanded;
    private boolean selected;
    private boolean selectable = true;
    private boolean partialSelected;
    private String rowKey;

    public CheckboxTreeNode() {
        this.type = DEFAULT_TYPE;
        this.children = new CheckboxTreeNodeChildren(this);
    }

    public CheckboxTreeNode(Object data) {
        this.type = DEFAULT_TYPE;
        this.children = new CheckboxTreeNodeChildren(this);
        this.data = data;
    }

    public CheckboxTreeNode(Object data, TreeNode parent) {
        this.type = DEFAULT_TYPE;
        this.data = data;
        this.children = new CheckboxTreeNodeChildren(this);
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    public CheckboxTreeNode(String type, Object data, TreeNode parent) {
        this.type = type;
        this.data = data;
        this.children = new CheckboxTreeNodeChildren(this);
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        if (children instanceof CheckboxTreeNodeChildren) {
            this.children = children;
        } else {
            CheckboxTreeNodeChildren nodeChildren = new CheckboxTreeNodeChildren(this);
            nodeChildren.addAll((Collection<? extends TreeNode>)children);
            this.children = nodeChildren;
        }
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    @Override
    public void clearParent() {
        this.parent = null;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value, boolean propagateDown, boolean propagateUp) {
        this.partialSelected = false;
        this.selected = value;
        if (propagateDown && propagateUp) {
            this.setSelected(value);
        } else if (!propagateDown && propagateUp) {
            if (this.getParent() != null) {
                ((CheckboxTreeNode)this.getParent()).propagateSelectionUp();
            }
        } else if (propagateDown && !propagateUp && !this.isLeaf()) {
            for (TreeNode child : this.children) {
                ((CheckboxTreeNode)child).propagateSelectionDown(value);
            }
        }
    }

    public void setSelected(boolean value, boolean propagate) {
        if (propagate) {
            this.setSelected(value);
        } else {
            this.selected = value;
        }
    }

    @Override
    public void setSelected(boolean value) {
        this.selected = value;
        this.partialSelected = false;
        if (!this.isLeaf()) {
            for (TreeNode child : this.children) {
                ((CheckboxTreeNode)child).propagateSelectionDown(value);
            }
        }
        if (this.getParent() != null) {
            ((CheckboxTreeNode)this.getParent()).propagateSelectionUp();
        }
    }

    protected void propagateSelectionDown(boolean value) {
        this.selected = value;
        this.partialSelected = false;
        for (TreeNode child : this.children) {
            ((CheckboxTreeNode)child).propagateSelectionDown(value);
        }
    }

    protected void propagateSelectionUp() {
        boolean allChildrenSelected = true;
        this.partialSelected = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode childNode = this.getChildren().get(i);
            boolean childSelected = childNode.isSelected();
            boolean childPartialSelected = childNode.isPartialSelected();
            allChildrenSelected = allChildrenSelected && childSelected;
            this.partialSelected = this.partialSelected || childSelected || childPartialSelected;
        }
        this.selected = allChildrenSelected;
        if (allChildrenSelected) {
            this.setPartialSelected(false);
        }
        if (this.getParent() != null) {
            ((CheckboxTreeNode)this.getParent()).propagateSelectionUp();
        }
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public String getRowKey() {
        return this.rowKey;
    }

    @Override
    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    @Override
    public boolean isLeaf() {
        if (this.children == null) {
            return true;
        }
        return this.children.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.rowKey == null ? 0 : this.rowKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheckboxTreeNode other = (CheckboxTreeNode)obj;
        if (this.data == null ? other.getData() != null : !this.data.equals(other.getData())) {
            return false;
        }
        return !(this.rowKey == null ? other.rowKey != null : !this.rowKey.equals(other.rowKey));
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    @Override
    public boolean isPartialSelected() {
        return this.partialSelected;
    }

    @Override
    public void setPartialSelected(boolean value) {
        this.partialSelected = value;
    }
}

