/*! http://keith-wood.name/signature.html
	Signature plugin for jQuery UI v1.2.0.
	Requires excanvas.js in IE.
	Written by Keith Wood (wood.keith{at}optusnet.com.au) April 2012.
	Available under the MIT (http://keith-wood.name/licence.html) license.
	Please attribute the author if you use it. */
(function(b){var a={options:{distance:0,background:"#fff",color:"#000",thickness:2,guideline:false,guidelineColor:"#a0a0a0",guidelineOffset:50,guidelineIndent:10,notAvailable:"Your browser doesn't support signing",syncField:null,syncFormat:"JSON",svgStyles:false,change:null},_create:function(){this.element.addClass(this.widgetFullName||this.widgetBaseClass);try{this.canvas=b('<canvas width="'+this.element.width()+'" height="'+this.element.height()+'">'+this.options.notAvailable+"</canvas>")[0];this.element.append(this.canvas)}catch(c){b(this.canvas).remove();this.resize=true;this.canvas=document.createElement("canvas");this.canvas.setAttribute("width",this.element.width());this.canvas.setAttribute("height",this.element.height());this.canvas.innerHTML=this.options.notAvailable;this.element.append(this.canvas);if(G_vmlCanvasManager){G_vmlCanvasManager.initElement(this.canvas)}}this.ctx=this.canvas.getContext("2d");this._refresh(true);this._mouseInit()},_refresh:function(d){if(this.resize){var c=b(this.canvas);b("div",this.canvas).css({width:c.width()+"px",height:c.height()+"px"})}this.ctx.fillStyle=this.options.background;this.ctx.strokeStyle=this.options.color;this.ctx.lineWidth=this.options.thickness;this.ctx.lineCap="round";this.ctx.lineJoin="round";this.clear(d)},clear:function(c){if(this.options.disabled){return}this.ctx.fillRect(0,0,this.element.width(),this.element.height());if(this.options.guideline){this.ctx.save();this.ctx.strokeStyle=this.options.guidelineColor;this.ctx.lineWidth=1;this.ctx.beginPath();this.ctx.moveTo(this.options.guidelineIndent,this.element.height()-this.options.guidelineOffset);this.ctx.lineTo(this.element.width()-this.options.guidelineIndent,this.element.height()-this.options.guidelineOffset);this.ctx.stroke();this.ctx.restore()}this.lines=[];if(!c){this._changed()}},_changed:function(d){if(this.options.syncField){var c="";switch(this.options.syncFormat){case"PNG":c=this.toDataURL();break;case"JPEG":c=this.toDataURL("image/jpeg");break;case"SVG":c=this.toSVG();break;default:c=this.toJSON()}b(this.options.syncField).val(c)}this._trigger("change",d,{})},_setOptions:function(){if(this._superApply){this._superApply(arguments)}else{b.Widget.prototype._setOptions.apply(this,arguments)}var d=0;var e=true;for(var c in arguments[0]){if(arguments[0].hasOwnProperty(c)){d++;e=e&&c==="disabled"}}if(d>1||!e){this._refresh()}},_mouseCapture:function(){return !this.options.disabled},_mouseStart:function(c){this.offset=this.element.offset();this.offset.left-=document.documentElement.scrollLeft||document.body.scrollLeft;this.offset.top-=document.documentElement.scrollTop||document.body.scrollTop;this.lastPoint=[this._round(c.clientX-this.offset.left),this._round(c.clientY-this.offset.top)];this.curLine=[this.lastPoint];this.lines.push(this.curLine)},_mouseDrag:function(d){var c=[this._round(d.clientX-this.offset.left),this._round(d.clientY-this.offset.top)];this.curLine.push(c);this.ctx.beginPath();this.ctx.moveTo(this.lastPoint[0],this.lastPoint[1]);this.ctx.lineTo(c[0],c[1]);this.ctx.stroke();this.lastPoint=c},_mouseStop:function(c){if(this.curLine.length===1){c.clientY+=this.options.thickness;this._mouseDrag(c)}this.lastPoint=null;this.curLine=null;this._changed(c)},_round:function(c){return Math.round(c*100)/100},toJSON:function(){return'{"lines":['+b.map(this.lines,function(c){return"["+b.map(c,function(d){return"["+d+"]"})+"]"})+"]}"},toSVG:function(){var d=(this.options.svgStyles?'style="fill: '+this.options.background+';"':'fill="'+this.options.background+'"');var c=(this.options.svgStyles?'style="fill: none; stroke: '+this.options.color+"; stroke-width: "+this.options.thickness+';"':'fill="none" stroke="'+this.options.color+'" stroke-width="'+this.options.thickness+'"');return'<?xml version="1.0"?>\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg xmlns="http://www.w3.org/2000/svg" width="15cm" height="15cm">\n	<g '+d+'>\n		<rect x="0" y="0" width="'+this.canvas.width+'" height="'+this.canvas.height+'"/>\n		<g '+c+">\n"+b.map(this.lines,function(e){return'			<polyline points="'+b.map(e,function(f){return f+""}).join(" ")+'"/>\n'}).join("")+"		</g>\n	</g>\n</svg>\n"},toDataURL:function(c,d){return this.canvas.toDataURL(c,d)},draw:function(c){if(this.options.disabled){return}this.clear(true);if(typeof c==="string"&&c.indexOf("data:")===0){this._drawDataURL(c)}else{if(typeof c==="string"&&c.indexOf("<svg")>-1){this._drawSVG(c)}else{this._drawJSON(c)}}this._changed()},_drawJSON:function(d){if(typeof d==="string"){d=b.parseJSON(d)}this.lines=d.lines||[];var c=this.ctx;b.each(this.lines,function(){c.beginPath();b.each(this,function(e){c[e===0?"moveTo":"lineTo"](this[0],this[1])});c.stroke()})},_drawSVG:function(e){var d=this.lines=[];b(e).find("polyline").each(function(){var f=[];b.each(b(this).attr("points").split(" "),function(h,g){var j=g.split(",");f.push([parseFloat(j[0]),parseFloat(j[1])])});d.push(f)});var c=this.ctx;b.each(this.lines,function(){c.beginPath();b.each(this,function(f){c[f===0?"moveTo":"lineTo"](this[0],this[1])});c.stroke()})},_drawDataURL:function(e){var d=new Image();var c=this.ctx;d.onload=function(){c.drawImage(this,0,0)};d.src=e},isEmpty:function(){return this.lines.length===0},_destroy:function(){this.element.removeClass(this.widgetFullName||this.widgetBaseClass);b(this.canvas).remove();this.canvas=this.ctx=this.lines=null;this._mouseDestroy()}};if(!b.Widget.prototype._destroy){b.extend(a,{destroy:function(){this._destroy();b.Widget.prototype.destroy.call(this)}})}if(b.Widget.prototype._getCreateOptions===b.noop){b.extend(a,{_getCreateOptions:function(){return b.metadata&&b.metadata.get(this.element[0])[this.widgetName]}})}b.widget("kbw.signature",b.ui.mouse,a);b.kbw.signature.options=b.kbw.signature.prototype.options})(jQuery);
PrimeFaces.widget.Signature=PrimeFaces.widget.BaseWidget.extend({init:function(a){this._super(a);this.input=this.jq.children(this.jqId+"_value");this.base64Input=this.jq.children(this.jqId+"_base64");this.cfg.syncField=this.input;var b=this;this.cfg.change=function(){b.handleChange()};this.render();if(this.cfg.readonly){this.jq.signature("disable")}},clear:function(){this.jq.signature("clear");this.input.val("");this.base64Input.val("")},draw:function(a){this.jq.signature("draw",a);if(this.cfg.base64){this.base64Input.val(this.canvasEL.toDataURL())}},render:function(){this.jq.signature(this.cfg);this.canvasEL=this.jq.children("canvas").get(0);var a=this.input.val();if(a){this.draw(a)}},handleChange:function(){if(this.cfg.base64){this.base64Input.val(this.canvasEL.toDataURL())}if(this.cfg.onchange){this.cfg.onchange.call(this)}}});
