/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces;

import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.primefaces.component.api.MultiViewStateAware;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.expression.ComponentNotFoundException;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.visit.ResetInputVisitCallback;

public class PrimeFaces {
    private static final Logger LOGGER = Logger.getLogger(PrimeFaces.class.getName());
    private static PrimeFaces instance = new PrimeFaces();
    private final Dialog dialog = new Dialog();
    private final Ajax ajax = new Ajax();
    private final MultiViewState multiViewState = new MultiViewState();

    protected PrimeFaces() {
    }

    public static PrimeFaces current() {
        return instance;
    }

    public static void setCurrent(PrimeFaces primeFaces) {
        instance = primeFaces;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected PrimeRequestContext getRequestContext() {
        return PrimeRequestContext.getCurrentInstance();
    }

    public boolean isFacesRequest() {
        return this.getFacesContext() != null;
    }

    public boolean isAjaxRequest() {
        FacesContext context = this.getFacesContext();
        if (context == null) {
            return false;
        }
        return context.getPartialViewContext().isAjaxRequest();
    }

    public void executeInitScript(String statement) {
        this.getRequestContext().getInitScriptsToExecute().add(statement);
    }

    public void executeScript(String statement) {
        this.getRequestContext().getScriptsToExecute().add(statement);
    }

    public void scrollTo(String clientId) {
        this.executeScript("PrimeFaces.scrollTo('" + clientId + "');");
    }

    public void focus(String expression) {
        this.focus(expression, (UIComponent)FacesContext.getCurrentInstance().getViewRoot());
    }

    public void focus(String expression, UIComponent base) {
        if (LangUtils.isValueBlank(expression)) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        String clientId = SearchExpressionFacade.resolveClientId(facesContext, base, expression);
        this.executeScript("PrimeFaces.focus('" + clientId + "');");
    }

    public void resetInputs(Collection<String> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        UIViewRoot root = facesContext.getViewRoot();
        for (String expression : expressions) {
            List<UIComponent> components = SearchExpressionFacade.resolveComponents(facesContext, (UIComponent)root, expression);
            for (UIComponent component : components) {
                component.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
            }
        }
    }

    public void resetInputs(String ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return;
        }
        this.resetInputs(Arrays.asList(expressions));
    }

    public Dialog dialog() {
        return this.dialog;
    }

    public Ajax ajax() {
        return this.ajax;
    }

    public MultiViewState multiViewState() {
        return this.multiViewState;
    }

    private static class MVSKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String viewId;
        private String clientId;

        private MVSKey() {
        }

        private MVSKey(String viewId, String clientId) {
            this.viewId = viewId;
            this.clientId = clientId;
        }

        public static MVSKey of(String viewId, String clientId) {
            return new MVSKey(viewId, clientId);
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + Objects.hashCode(this.viewId);
            hash = 23 * hash + Objects.hashCode(this.clientId);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MVSKey other = (MVSKey)obj;
            return Objects.equals(this.viewId, other.viewId) && Objects.equals(this.clientId, other.clientId);
        }

        public String toString() {
            return "MVSKey{viewId='" + this.viewId + '\'' + ", clientId='" + this.clientId + '\'' + '}';
        }
    }

    public class MultiViewState {
        public void clearAll() {
            this.clearAll(true, null);
        }

        public void clearAll(boolean reset) {
            this.clearAll(reset, null);
        }

        public void clearAll(boolean reset, Consumer<String> clientIdConsumer) {
            if (reset || clientIdConsumer != null) {
                Set<MVSKey> keys = Collections.unmodifiableSet(this.getMVSKeys());
                this.clearMVSKeys(keys, reset, clientIdConsumer);
            }
            PrimeFaces.this.getFacesContext().getExternalContext().getSessionMap().remove("primefaces.MULTI_VIEW_STATES");
        }

        public void clearAll(String viewId, boolean reset) {
            this.clearAll(viewId, reset, null);
        }

        public void clearAll(String viewId, boolean reset, Consumer<String> clientIdConsumer) {
            Set<MVSKey> keys = this.getMVSKeys().stream().filter(k -> Objects.equals(((MVSKey)k).viewId, viewId)).collect(Collectors.toSet());
            if (!keys.isEmpty()) {
                this.clearMVSKeys(keys, reset, clientIdConsumer);
            }
        }

        public void clear(String viewId, String clientId) {
            this.clear(viewId, clientId, true);
        }

        public void clear(String viewId, String clientId, boolean reset) {
            MVSKey key = MVSKey.of(viewId, clientId);
            this.clearMVSKeys(Collections.singleton(key), reset, null);
        }

        public <T> T get(String viewId, String clientId, boolean create, Supplier<T> supplier) {
            MVSKey mvsKey;
            Map<MVSKey, Object> mvsMap = this.getMVSStore(create);
            Object state = mvsMap.get(mvsKey = MVSKey.of(viewId, clientId));
            if (state == null && create) {
                state = supplier.get();
                mvsMap.put(mvsKey, state);
            }
            return (T)state;
        }

        private Set<MVSKey> getMVSKeys() {
            return this.getMVSStore(false).keySet();
        }

        private Map<MVSKey, Object> getMVSStore(boolean create) {
            Map mvsMap;
            ConcurrentHashMap clientWindowMap;
            ExternalContext externalContext;
            ClientWindow clientWindow;
            FacesContext fc = PrimeFaces.this.getFacesContext();
            Map sessionMap = fc.getExternalContext().getSessionMap();
            PrimeApplicationContext primeApplicationContext = PrimeApplicationContext.getCurrentInstance(fc);
            String clientWindowId = "session";
            if (primeApplicationContext.getEnvironment().isAtLeastJsf22() && "client-window".equals(primeApplicationContext.getConfig().getMultiViewStateStore()) && (clientWindow = (externalContext = fc.getExternalContext()).getClientWindow()) != null && !LangUtils.isValueBlank(clientWindow.getId())) {
                clientWindowId = clientWindow.getId();
            }
            if ((clientWindowMap = (ConcurrentHashMap)sessionMap.get("primefaces.MULTI_VIEW_STATES")) == null) {
                clientWindowMap = new ConcurrentHashMap();
                sessionMap.put("primefaces.MULTI_VIEW_STATES", clientWindowMap);
            }
            if ((mvsMap = (Map)clientWindowMap.get(clientWindowId)) == null) {
                if (create) {
                    mvsMap = new ConcurrentHashMap();
                    clientWindowMap.put(clientWindowId, mvsMap);
                } else {
                    mvsMap = Collections.emptyMap();
                }
            }
            return mvsMap;
        }

        private void reset(String clientId) {
            FacesContext context = PrimeFaces.this.getFacesContext();
            context.getViewRoot().invokeOnComponent(context, clientId, (fc, component) -> {
                if (!(component instanceof MultiViewStateAware)) {
                    throw new FacesException("Multi view state not supported for: " + component.getClass().getSimpleName());
                }
                ((MultiViewStateAware)component).resetMultiViewState();
            });
        }

        private void clearMVSKeys(Set<MVSKey> keysToRemove, boolean reset, Consumer<String> clientIdConsumer) {
            Set<MVSKey> mvsKeys = this.getMVSKeys();
            for (MVSKey mvsKey : keysToRemove) {
                if (!mvsKeys.remove(mvsKey)) {
                    LOGGER.log(Level.WARNING, "Multiview state for viewId: \"{0}\" and clientId \"{1}\" not found", new Object[]{mvsKey.viewId, mvsKey.clientId});
                    continue;
                }
                if (reset) {
                    this.reset(mvsKey.clientId);
                }
                if (clientIdConsumer == null) continue;
                clientIdConsumer.accept(mvsKey.clientId);
            }
        }
    }

    public class Ajax {
        public void addCallbackParam(String name, Object value) {
            PrimeFaces.this.getRequestContext().getCallbackParams().put(name, value);
        }

        public void update(Collection<String> expressions) {
            if (expressions == null || expressions.isEmpty()) {
                return;
            }
            FacesContext facesContext = PrimeFaces.this.getFacesContext();
            for (String expression : expressions) {
                if (LangUtils.isValueBlank(expression)) continue;
                try {
                    String clientId = SearchExpressionFacade.resolveClientId(facesContext, (UIComponent)facesContext.getViewRoot(), expression);
                    facesContext.getPartialViewContext().getRenderIds().add(clientId);
                }
                catch (ComponentNotFoundException e) {
                    if (facesContext.isProjectStage(ProjectStage.Development)) {
                        LOGGER.log(Level.WARNING, "PrimeFaces.current().ajax().update() called but component can't be resolved! Expression will just be added to the renderIds: {0}", expression);
                    }
                    facesContext.getPartialViewContext().getRenderIds().add(expression);
                }
            }
        }

        public void update(String ... expressions) {
            if (expressions == null || expressions.length == 0) {
                return;
            }
            this.update(Arrays.asList(expressions));
        }

        public void update(UIComponent ... components) {
            if (components == null || components.length == 0) {
                return;
            }
            FacesContext facesContext = PrimeFaces.this.getFacesContext();
            for (UIComponent component : components) {
                facesContext.getPartialViewContext().getRenderIds().add(component.getClientId(facesContext));
            }
        }

        public void ignoreAutoUpdate() {
            PrimeRequestContext.getCurrentInstance().setIgnoreAutoUpdate(true);
        }
    }

    public class Dialog {
        public void openDynamic(String outcome) {
            PrimeFaces.this.getFacesContext().getAttributes().put("dialog.outcome", outcome);
        }

        public void openDynamic(String outcome, Map<String, Object> options, Map<String, List<String>> params) {
            FacesContext facesContext = PrimeFaces.this.getFacesContext();
            facesContext.getAttributes().put("dialog.outcome", outcome);
            if (options != null) {
                facesContext.getAttributes().put("dialog.options", options);
            }
            if (params != null) {
                facesContext.getAttributes().put("dialog.params", params);
            }
        }

        public void closeDynamic(Object data) {
            FacesContext facesContext = PrimeFaces.this.getFacesContext();
            Map params = facesContext.getExternalContext().getRequestParameterMap();
            String pfdlgcid = (String)params.get("pfdlgcid");
            if (data != null) {
                Map session = facesContext.getExternalContext().getSessionMap();
                session.put(pfdlgcid, data);
            }
            PrimeFaces.this.executeScript("PrimeFaces.closeDialog({pfdlgcid:'" + EscapeUtils.forJavaScript(pfdlgcid) + "'});");
        }

        public void showMessageDynamic(FacesMessage message) {
            this.showMessageDynamic(message, true);
        }

        public void showMessageDynamic(FacesMessage message, boolean escape) {
            String summary = EscapeUtils.forJavaScript(message.getSummary());
            String detail = EscapeUtils.forJavaScript(message.getDetail());
            PrimeFaces.this.executeScript("PrimeFaces.showMessageInDialog({severity:\"" + message.getSeverity() + "\",summary:\"" + summary + "\",detail:\"" + detail + "\",escape:" + escape + "});");
        }
    }
}

