/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import java.util.List;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.util.Lazy;
import org.primefaces.util.ResourceUtils;

public class DynamicResourcesPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final String INITIAL_RESOURCES = DynamicResourcesPhaseListener.class.getName() + ".INITIAL_RESOURCES";
    private Lazy<Boolean> enabled = new Lazy(() -> !PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getEnvironment().isAtLeastJsf23());

    public void beforePhase(PhaseEvent event) {
    }

    public void afterPhase(PhaseEvent event) {
        if (Boolean.FALSE.equals(this.enabled.get())) {
            return;
        }
        FacesContext context = event.getFacesContext();
        if (context.getViewRoot() == null || !context.getPartialViewContext().isAjaxRequest()) {
            return;
        }
        if (!context.isPostback()) {
            return;
        }
        if (context.getPartialViewContext().isRenderAll()) {
            return;
        }
        List<ResourceUtils.ResourceInfo> initialResources = ResourceUtils.getComponentResources(context);
        DynamicResourcesPhaseListener.putInitialResources(context, initialResources);
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public static void putInitialResources(FacesContext context, List<ResourceUtils.ResourceInfo> resources) {
        context.getAttributes().put(INITIAL_RESOURCES, resources);
    }

    public static List<ResourceUtils.ResourceInfo> getInitialResources(FacesContext context) {
        return (List)context.getAttributes().get(INITIAL_RESOURCES);
    }
}

