/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import java.util.regex.Pattern;
import org.primefaces.util.LangUtils;

public interface Widget {
    public static final String CALLBACK_POST_CONSTRUCT = "widgetPostConstruct";
    public static final String CALLBACK_POST_REFRESH = "widgetPostRefresh";
    public static final String CALLBACK_PRE_DESTROY = "widgetPreDestroy";
    public static final String ATTR_WIDGET_VAR_PATTERN = Widget.class.getName() + ".ATTR_WIDGET_VAR_PATTERN";

    default public String resolveWidgetVar() {
        return this.resolveWidgetVar(FacesContext.getCurrentInstance());
    }

    default public String resolveWidgetVar(FacesContext context) {
        UIComponent component = (UIComponent)this;
        String userWidgetVar = (String)component.getAttributes().get("widgetVar");
        if (!LangUtils.isValueBlank(userWidgetVar)) {
            return userWidgetVar;
        }
        Pattern pattern = (Pattern)context.getAttributes().get(ATTR_WIDGET_VAR_PATTERN);
        if (pattern == null) {
            pattern = Pattern.compile("-|" + UINamingContainer.getSeparatorChar((FacesContext)context));
            context.getAttributes().put(ATTR_WIDGET_VAR_PATTERN, pattern);
        }
        String widgetVar = "widget_" + component.getClientId(context);
        return pattern.matcher(widgetVar).replaceAll("_");
    }
}

