/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.avatar;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.component.avatar.Avatar;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;

public class AvatarRenderer
extends CoreRenderer {
    private static final Pattern LETTER_PATTTERN = Pattern.compile("\\b[a-zA-Z]");
    private static final String GRAVATAR_URL = "http://www.gravatar.com/avatar/";
    private static final String SB_AVATAR = AvatarRenderer.class.getName() + "#avatar";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Avatar avatar = (Avatar)component;
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-avatar ui-widget").add(avatar.getStyleClass()).add("circle".equals(avatar.getShape()), "ui-avatar-circle").add("large".equals(avatar.getSize()), "ui-avatar-lg").add("xlarge".equals(avatar.getSize()), "ui-avatar-xl").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)avatar.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        String label = this.calculateLabel(context, avatar);
        String style = avatar.getStyle();
        if (avatar.isDynamicColor() && label != null) {
            String colorCss = this.generateBackgroundColor(avatar.getLabel());
            String string = style = style == null ? colorCss : colorCss + style;
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (avatar.getChildCount() > 0) {
            this.renderChildren(context, (UIComponent)avatar);
        } else {
            this.encodeDefaultContent(context, avatar, label);
        }
        writer.endElement("div");
    }

    protected void encodeDefaultContent(FacesContext context, Avatar avatar, String label) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (LangUtils.isNotBlank(label)) {
            writer.startElement("span", null);
            String textClass = this.getStyleClassBuilder(context).add("ui-avatar-text").add(avatar.isDynamicColor(), "ui-avatar-dynamic").build();
            writer.writeAttribute("class", (Object)textClass, "styleClass");
            writer.write(label);
            writer.endElement("span");
        } else if (avatar.getIcon() != null) {
            String iconStyleClass = this.getStyleClassBuilder(context).add("ui-avatar-icon").add(avatar.getIcon()).build();
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconStyleClass, "styleClass");
            writer.endElement("span");
        } else if (avatar.getGravatar() != null) {
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)this.generateGravatar(context, avatar), "src");
            writer.endElement("img");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String calculateLabel(FacesContext context, Avatar avatar) {
        String value = avatar.getLabel();
        if (value == null || value.length() <= 2) {
            return value;
        }
        Matcher m = LETTER_PATTTERN.matcher(value);
        StringBuilder sb = SharedStringBuilder.get(context, SB_AVATAR);
        while (m.find()) {
            sb.append(m.group());
        }
        String initials = sb.toString();
        initials = initials.length() == 1 ? initials : initials.charAt(0) + initials.substring(initials.length() - 1);
        return initials;
    }

    protected String generateBackgroundColor(String label) {
        return "color:#fff;background-color: hsl(" + Math.abs(label.hashCode() % 40 * 9) + ", 100%, 50%);";
    }

    protected String generateGravatar(FacesContext context, Avatar avatar) {
        String url;
        String email = avatar.getGravatar();
        String config = avatar.getGravatarConfig();
        try {
            StringBuilder sb = SharedStringBuilder.get(context, SB_AVATAR);
            sb.append(GRAVATAR_URL);
            this.generateMailHash(sb, email);
            if (LangUtils.isNotBlank(config)) {
                sb.append('?').append(config);
            }
            url = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new FacesException("Failed to generate Gravatar URL for value: " + email);
        }
        return url;
    }

    protected void generateMailHash(StringBuilder sb, String email) throws NoSuchAlgorithmException {
        byte[] digest;
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(email.getBytes(StandardCharsets.UTF_8));
        for (byte b : digest = md.digest()) {
            sb.append(String.format("%02x", b & 0xFF));
        }
    }
}

