/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.badge;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.badge.Badge;
import org.primefaces.renderkit.CoreRenderer;

public class BadgeRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Badge badge = (Badge)component;
        ResponseWriter writer = context.getResponseWriter();
        String value = badge.getValue();
        boolean hasChild = badge.getChildCount() > 0;
        String severity = badge.getSeverity();
        String size = badge.getSize();
        String styleClass = this.getStyleClassBuilder(context).add("ui-badge ui-widget").add(badge.getStyleClass()).add(value != null && value.length() == 1, "ui-badge-no-gutter").add(value == null, "ui-badge-dot").add("large".equals(size), "ui-badge-lg").add("xlarge".equals(size), "ui-badge-xl").add("info".equals(severity), "ui-badge-info").add("success".equals(severity), "ui-badge-success").add("warning".equals(severity), "ui-badge-warning").add("danger".equals(severity), "ui-badge-danger").build();
        if (hasChild) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-overlay-badge", "styleClass");
        }
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)badge.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (badge.getStyle() != null) {
            writer.writeAttribute("style", (Object)badge.getStyle(), "style");
        }
        if (value != null) {
            writer.write(value);
        }
        writer.endElement("span");
        if (hasChild) {
            this.renderChildren(context, (UIComponent)badge);
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

